/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.operation;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonInt64;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.Decoder;
import com.willfp.eco.libs.mongodb.MongoCommandException;
import com.willfp.eco.libs.mongodb.MongoNamespace;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.internal.async.AsyncBatchCursor;
import com.willfp.eco.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import com.willfp.eco.libs.mongodb.internal.async.SingleResultCallback;
import com.willfp.eco.libs.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.willfp.eco.libs.mongodb.internal.async.function.RetryState;
import com.willfp.eco.libs.mongodb.internal.binding.AsyncConnectionSource;
import com.willfp.eco.libs.mongodb.internal.binding.AsyncReadBinding;
import com.willfp.eco.libs.mongodb.internal.binding.ReadBinding;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncReadOperation;
import com.willfp.eco.libs.mongodb.internal.operation.BatchCursor;
import com.willfp.eco.libs.mongodb.internal.operation.CommandOperationHelper;
import com.willfp.eco.libs.mongodb.internal.operation.CommandResultDocumentCodec;
import com.willfp.eco.libs.mongodb.internal.operation.CursorHelper;
import com.willfp.eco.libs.mongodb.internal.operation.DocumentHelper;
import com.willfp.eco.libs.mongodb.internal.operation.OperationHelper;
import com.willfp.eco.libs.mongodb.internal.operation.ReadOperation;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class ListIndexesOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private boolean retryReads;
    private int batchSize;
    private long maxTimeMS;
    private BsonValue comment;

    public ListIndexesOperation(MongoNamespace namespace, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public ListIndexesOperation<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public ListIndexesOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public ListIndexesOperation<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public ListIndexesOperation<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads);
        Supplier<BatchCursor> read2 = CommandOperationHelper.decorateReadWithRetries(retryState, binding.getOperationContext(), () -> OperationHelper.withSourceAndConnection(binding::getReadConnectionSource, false, (source, connection) -> {
            retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), binding.getSessionContext()));
            try {
                return CommandOperationHelper.createReadCommandAndExecute(retryState, binding, source, this.namespace.getDatabaseName(), this.getCommandCreator(), this.createCommandDecoder(), this.transformer(), connection);
            }
            catch (MongoCommandException e) {
                return CommandOperationHelper.rethrowIfNotNamespaceError(e, OperationHelper.createEmptyBatchCursor(this.namespace, this.decoder, source.getServerDescription().getAddress(), this.batchSize));
            }
        }));
        return read2.get();
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads);
        binding.retain();
        AsyncCallbackSupplier<AsyncBatchCursor<T>> asyncRead = CommandOperationHelper.decorateReadWithRetries(retryState, binding.getOperationContext(), funcCallback -> OperationHelper.withAsyncSourceAndConnection(binding::getReadConnectionSource, false, funcCallback, (source, connection, releasingCallback) -> {
            if (retryState.breakAndCompleteIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), binding.getSessionContext()), releasingCallback)) {
                return;
            }
            CommandOperationHelper.createReadCommandAndExecuteAsync(retryState, binding, source, this.namespace.getDatabaseName(), this.getCommandCreator(), this.createCommandDecoder(), this.asyncTransformer(), connection, (result2, t2) -> {
                if (t2 != null && !CommandOperationHelper.isNamespaceError(t2)) {
                    releasingCallback.onResult(null, t2);
                } else {
                    releasingCallback.onResult(result2 != null ? result2 : this.emptyAsyncCursor((AsyncConnectionSource)source), null);
                }
            });
        })).whenComplete(binding::release);
        asyncRead.get(ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private AsyncBatchCursor<T> emptyAsyncCursor(AsyncConnectionSource source) {
        return OperationHelper.createEmptyAsyncBatchCursor(this.namespace, source.getServerDescription().getAddress());
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (serverDescription, connectionDescription) -> this.getCommand();
    }

    private BsonDocument getCommand() {
        BsonDocument command2 = new BsonDocument("listIndexes", new BsonString(this.namespace.getCollectionName())).append("cursor", CursorHelper.getCursorDocumentFromBatchSize(this.batchSize == 0 ? null : Integer.valueOf(this.batchSize)));
        if (this.maxTimeMS > 0L) {
            command2.put("maxTimeMS", new BsonInt64(this.maxTimeMS));
        }
        DocumentHelper.putIfNotNull(command2, "comment", this.comment);
        return command2;
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, BatchCursor<T>> transformer() {
        return (result2, source, connection) -> OperationHelper.cursorDocumentToBatchCursor(result2.getDocument("cursor"), this.decoder, this.comment, source, connection, this.batchSize);
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return (result2, source, connection) -> OperationHelper.cursorDocumentToAsyncBatchCursor(result2.getDocument("cursor"), this.decoder, this.comment, source, connection, this.batchSize);
    }

    private Codec<BsonDocument> createCommandDecoder() {
        return CommandResultDocumentCodec.create(this.decoder, "firstBatch");
    }
}

