/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.operation;

import com.willfp.eco.libs.bson.BsonArray;
import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.mongodb.MongoException;
import com.willfp.eco.libs.mongodb.MongoWriteConcernException;
import com.willfp.eco.libs.mongodb.ServerAddress;
import com.willfp.eco.libs.mongodb.WriteConcern;
import com.willfp.eco.libs.mongodb.WriteConcernResult;
import com.willfp.eco.libs.mongodb.bulk.WriteConcernError;
import com.willfp.eco.libs.mongodb.internal.connection.ProtocolHelper;
import com.willfp.eco.libs.mongodb.internal.operation.CommandOperationHelper;
import java.util.stream.Collectors;

public final class WriteConcernHelper {
    public static void appendWriteConcernToCommand(WriteConcern writeConcern, BsonDocument commandDocument) {
        if (writeConcern != null && !writeConcern.isServerDefault()) {
            commandDocument.put("writeConcern", writeConcern.asDocument());
        }
    }

    public static void throwOnWriteConcernError(BsonDocument result2, ServerAddress serverAddress, int maxWireVersion) {
        if (WriteConcernHelper.hasWriteConcernError(result2)) {
            MongoException exception = ProtocolHelper.createSpecialException(result2, serverAddress, "errmsg");
            if (exception == null) {
                exception = WriteConcernHelper.createWriteConcernException(result2, serverAddress);
            }
            CommandOperationHelper.addRetryableWriteErrorLabel(exception, maxWireVersion);
            throw exception;
        }
    }

    public static boolean hasWriteConcernError(BsonDocument result2) {
        return result2.containsKey("writeConcernError");
    }

    public static MongoWriteConcernException createWriteConcernException(BsonDocument result2, ServerAddress serverAddress) {
        MongoWriteConcernException writeConcernException = new MongoWriteConcernException(WriteConcernHelper.createWriteConcernError(result2.getDocument("writeConcernError")), WriteConcernResult.acknowledged(0, false, null), serverAddress);
        result2.getArray("errorLabels", new BsonArray()).stream().map(i -> i.asString().getValue()).forEach(writeConcernException::addLabel);
        return writeConcernException;
    }

    public static WriteConcernError createWriteConcernError(BsonDocument writeConcernErrorDocument) {
        return new WriteConcernError(writeConcernErrorDocument.getNumber("code").intValue(), writeConcernErrorDocument.getString("codeName", new BsonString("")).getValue(), writeConcernErrorDocument.getString("errmsg").getValue(), writeConcernErrorDocument.getDocument("errInfo", new BsonDocument()), writeConcernErrorDocument.getArray("errorLabels", new BsonArray()).stream().map(i -> i.asString().getValue()).collect(Collectors.toSet()));
    }

    private WriteConcernHelper() {
    }
}

