/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client;

import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import com.willfp.eco.libs.mongodb.ConnectionString;
import com.willfp.eco.libs.mongodb.MongoClientSettings;
import com.willfp.eco.libs.mongodb.MongoDriverInformation;
import com.willfp.eco.libs.mongodb.MongoInternalException;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.connection.AsynchronousSocketChannelStreamFactoryFactory;
import com.willfp.eco.libs.mongodb.connection.StreamFactory;
import com.willfp.eco.libs.mongodb.connection.StreamFactoryFactory;
import com.willfp.eco.libs.mongodb.connection.TlsChannelStreamFactoryFactory;
import com.willfp.eco.libs.mongodb.internal.connection.Cluster;
import com.willfp.eco.libs.mongodb.internal.connection.DefaultClusterFactory;
import com.willfp.eco.libs.mongodb.internal.connection.InternalConnectionPoolSettings;
import com.willfp.eco.libs.mongodb.internal.event.EventListenerHelper;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.reactivestreams.client.MongoClient;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.MongoClientImpl;
import java.io.Closeable;

public final class MongoClients {
    public static MongoClient create() {
        return MongoClients.create(new ConnectionString("mongodb://localhost"));
    }

    public static MongoClient create(String connectionString) {
        return MongoClients.create(new ConnectionString(connectionString));
    }

    public static MongoClient create(ConnectionString connectionString) {
        return MongoClients.create(connectionString, null);
    }

    public static MongoClient create(ConnectionString connectionString, @Nullable MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(MongoClientSettings.builder().applyConnectionString(connectionString).build(), mongoDriverInformation);
    }

    public static MongoClient create(MongoClientSettings settings) {
        return MongoClients.create(settings, null);
    }

    public static MongoClient create(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        if (settings.getStreamFactoryFactory() == null) {
            if (settings.getSslSettings().isEnabled()) {
                return MongoClients.createWithTlsChannel(settings, mongoDriverInformation);
            }
            return MongoClients.createWithAsynchronousSocketChannel(settings, mongoDriverInformation);
        }
        return MongoClients.createMongoClient(settings, mongoDriverInformation, MongoClients.getStreamFactory(settings, false), MongoClients.getStreamFactory(settings, true), null);
    }

    public static CodecRegistry getDefaultCodecRegistry() {
        return MongoClientSettings.getDefaultCodecRegistry();
    }

    private static MongoClient createMongoClient(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, @Nullable Closeable externalResourceCloser) {
        MongoDriverInformation wrappedMongoDriverInformation = MongoClients.wrapMongoDriverInformation(mongoDriverInformation);
        return new MongoClientImpl(settings, wrappedMongoDriverInformation, MongoClients.createCluster(settings, wrappedMongoDriverInformation, streamFactory, heartbeatStreamFactory), externalResourceCloser);
    }

    private static Cluster createCluster(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory) {
        Assertions.notNull("settings", settings);
        return new DefaultClusterFactory().createCluster(settings.getClusterSettings(), settings.getServerSettings(), settings.getConnectionPoolSettings(), InternalConnectionPoolSettings.builder().prestartAsyncWorkManager(true).build(), streamFactory, heartbeatStreamFactory, settings.getCredential(), settings.getLoggerSettings(), EventListenerHelper.getCommandListener(settings.getCommandListeners()), settings.getApplicationName(), mongoDriverInformation, settings.getCompressorList(), settings.getServerApi(), settings.getDnsClient(), settings.getInetAddressResolver());
    }

    private static MongoDriverInformation wrapMongoDriverInformation(@Nullable MongoDriverInformation mongoDriverInformation) {
        return (mongoDriverInformation == null ? MongoDriverInformation.builder() : MongoDriverInformation.builder(mongoDriverInformation)).driverName("reactive-streams").build();
    }

    private static MongoClient createWithTlsChannel(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        TlsChannelStreamFactoryFactory streamFactoryFactory = new TlsChannelStreamFactoryFactory();
        StreamFactory streamFactory = streamFactoryFactory.create(settings.getSocketSettings(), settings.getSslSettings());
        StreamFactory heartbeatStreamFactory = streamFactoryFactory.create(settings.getHeartbeatSocketSettings(), settings.getSslSettings());
        return MongoClients.createMongoClient(settings, mongoDriverInformation, streamFactory, heartbeatStreamFactory, streamFactoryFactory);
    }

    private static MongoClient createWithAsynchronousSocketChannel(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        AsynchronousSocketChannelStreamFactoryFactory streamFactoryFactory = AsynchronousSocketChannelStreamFactoryFactory.builder().build();
        StreamFactory streamFactory = streamFactoryFactory.create(settings.getSocketSettings(), settings.getSslSettings());
        StreamFactory heartbeatStreamFactory = streamFactoryFactory.create(settings.getHeartbeatSocketSettings(), settings.getSslSettings());
        return MongoClients.createMongoClient(settings, mongoDriverInformation, streamFactory, heartbeatStreamFactory, null);
    }

    private static StreamFactory getStreamFactory(MongoClientSettings settings, boolean isHeartbeat) {
        StreamFactoryFactory streamFactoryFactory = settings.getStreamFactoryFactory();
        if (streamFactoryFactory == null) {
            throw new MongoInternalException("should not happen");
        }
        return streamFactoryFactory.create(isHeartbeat ? settings.getHeartbeatSocketSettings() : settings.getSocketSettings(), settings.getSslSettings());
    }

    private MongoClients() {
    }
}

