/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client;

import com.willfp.eco.libs.bson.Document;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import com.willfp.eco.libs.bson.conversions.Bson;
import com.willfp.eco.libs.mongodb.ReadConcern;
import com.willfp.eco.libs.mongodb.ReadPreference;
import com.willfp.eco.libs.mongodb.WriteConcern;
import com.willfp.eco.libs.mongodb.annotations.ThreadSafe;
import com.willfp.eco.libs.mongodb.client.model.CreateCollectionOptions;
import com.willfp.eco.libs.mongodb.client.model.CreateViewOptions;
import com.willfp.eco.libs.mongodb.reactivestreams.client.AggregatePublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ClientSession;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ListCollectionsPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.MongoCollection;
import com.willfp.eco.libs.reactivestreams.Publisher;
import java.util.List;

@ThreadSafe
public interface MongoDatabase {
    public String getName();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public ReadConcern getReadConcern();

    public MongoDatabase withCodecRegistry(CodecRegistry var1);

    public MongoDatabase withReadPreference(ReadPreference var1);

    public MongoDatabase withWriteConcern(WriteConcern var1);

    public MongoDatabase withReadConcern(ReadConcern var1);

    public MongoCollection<Document> getCollection(String var1);

    public <TDocument> MongoCollection<TDocument> getCollection(String var1, Class<TDocument> var2);

    public Publisher<Document> runCommand(Bson var1);

    public Publisher<Document> runCommand(Bson var1, ReadPreference var2);

    public <TResult> Publisher<TResult> runCommand(Bson var1, Class<TResult> var2);

    public <TResult> Publisher<TResult> runCommand(Bson var1, ReadPreference var2, Class<TResult> var3);

    public Publisher<Document> runCommand(ClientSession var1, Bson var2);

    public Publisher<Document> runCommand(ClientSession var1, Bson var2, ReadPreference var3);

    public <TResult> Publisher<TResult> runCommand(ClientSession var1, Bson var2, Class<TResult> var3);

    public <TResult> Publisher<TResult> runCommand(ClientSession var1, Bson var2, ReadPreference var3, Class<TResult> var4);

    public Publisher<Void> drop();

    public Publisher<Void> drop(ClientSession var1);

    public Publisher<String> listCollectionNames();

    public Publisher<String> listCollectionNames(ClientSession var1);

    public ListCollectionsPublisher<Document> listCollections();

    public <TResult> ListCollectionsPublisher<TResult> listCollections(Class<TResult> var1);

    public ListCollectionsPublisher<Document> listCollections(ClientSession var1);

    public <TResult> ListCollectionsPublisher<TResult> listCollections(ClientSession var1, Class<TResult> var2);

    public Publisher<Void> createCollection(String var1);

    public Publisher<Void> createCollection(String var1, CreateCollectionOptions var2);

    public Publisher<Void> createCollection(ClientSession var1, String var2);

    public Publisher<Void> createCollection(ClientSession var1, String var2, CreateCollectionOptions var3);

    public Publisher<Void> createView(String var1, String var2, List<? extends Bson> var3);

    public Publisher<Void> createView(String var1, String var2, List<? extends Bson> var3, CreateViewOptions var4);

    public Publisher<Void> createView(ClientSession var1, String var2, String var3, List<? extends Bson> var4);

    public Publisher<Void> createView(ClientSession var1, String var2, String var3, List<? extends Bson> var4, CreateViewOptions var5);

    public ChangeStreamPublisher<Document> watch();

    public <TResult> ChangeStreamPublisher<TResult> watch(Class<TResult> var1);

    public ChangeStreamPublisher<Document> watch(List<? extends Bson> var1);

    public <TResult> ChangeStreamPublisher<TResult> watch(List<? extends Bson> var1, Class<TResult> var2);

    public ChangeStreamPublisher<Document> watch(ClientSession var1);

    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession var1, Class<TResult> var2);

    public ChangeStreamPublisher<Document> watch(ClientSession var1, List<? extends Bson> var2);

    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession var1, List<? extends Bson> var2, Class<TResult> var3);

    public AggregatePublisher<Document> aggregate(List<? extends Bson> var1);

    public <TResult> AggregatePublisher<TResult> aggregate(List<? extends Bson> var1, Class<TResult> var2);

    public AggregatePublisher<Document> aggregate(ClientSession var1, List<? extends Bson> var2);

    public <TResult> AggregatePublisher<TResult> aggregate(ClientSession var1, List<? extends Bson> var2, Class<TResult> var3);
}

