/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal;

import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.BatchCursor;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.BatchCursorPublisher;
import com.willfp.eco.libs.reactivestreams.Publisher;
import com.willfp.eco.libs.reactivestreams.Subscriber;
import com.willfp.eco.libs.reactor.core.CoreSubscriber;
import com.willfp.eco.libs.reactor.core.publisher.Flux;
import com.willfp.eco.libs.reactor.core.publisher.FluxSink;
import com.willfp.eco.libs.reactor.core.publisher.Mono;
import com.willfp.eco.libs.reactor.util.context.Context;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

class BatchCursorFlux<T>
implements Publisher<T> {
    private final BatchCursorPublisher<T> batchCursorPublisher;
    private final AtomicBoolean inProgress = new AtomicBoolean(false);
    private final AtomicLong demandDelta = new AtomicLong(0L);
    private volatile BatchCursor<T> batchCursor;
    private FluxSink<T> sink;

    BatchCursorFlux(BatchCursorPublisher<T> batchCursorPublisher) {
        this.batchCursorPublisher = batchCursorPublisher;
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber) {
        Flux.create(sink -> {
            this.sink = sink;
            sink.onRequest(demand -> {
                if (this.calculateDemand(demand) > 0L && this.inProgress.compareAndSet(false, true)) {
                    if (this.batchCursor == null) {
                        int batchSize = this.calculateBatchSize(sink.requestedFromDownstream());
                        Context initialContext = subscriber instanceof CoreSubscriber ? ((CoreSubscriber)subscriber).currentContext() : null;
                        this.batchCursorPublisher.batchCursor(batchSize).subscribe(bc -> {
                            this.batchCursor = bc;
                            this.inProgress.set(false);
                            if (sink.isCancelled()) {
                                this.closeCursor();
                            } else {
                                this.recurseCursor();
                            }
                        }, sink::error, null, initialContext);
                    } else {
                        this.inProgress.set(false);
                        this.recurseCursor();
                    }
                }
            });
            sink.onCancel(this::closeCursor);
            sink.onDispose(this::closeCursor);
        }, FluxSink.OverflowStrategy.BUFFER).subscribe(subscriber);
    }

    private void closeCursor() {
        if (this.batchCursor != null) {
            this.batchCursor.close();
        }
    }

    private void recurseCursor() {
        if (!this.sink.isCancelled() && this.sink.requestedFromDownstream() > 0L && this.inProgress.compareAndSet(false, true)) {
            if (this.batchCursor.isClosed()) {
                this.sink.complete();
            } else {
                this.batchCursor.setBatchSize(this.calculateBatchSize(this.sink.requestedFromDownstream()));
                Mono.from(this.batchCursor.next(() -> this.sink.isCancelled())).doOnCancel(this::closeCursor).doOnError(e -> {
                    try {
                        this.closeCursor();
                    }
                    finally {
                        this.sink.error((Throwable)e);
                    }
                }).doOnSuccess(results -> {
                    if (results != null) {
                        results.stream().filter(Objects::nonNull).forEach(this.sink::next);
                        this.calculateDemand(-results.size());
                    }
                    if (this.batchCursor.isClosed()) {
                        this.sink.complete();
                    } else {
                        this.inProgress.set(false);
                        this.recurseCursor();
                    }
                }).subscribe();
            }
        }
    }

    long calculateDemand(long demand) {
        return this.demandDelta.accumulateAndGet(demand, (originalValue, update2) -> {
            long newValue = originalValue + update2;
            return update2 > 0L && newValue < originalValue ? Long.MAX_VALUE : newValue;
        });
    }

    int calculateBatchSize(long demand) {
        Integer setBatchSize = this.batchCursorPublisher.getBatchSize();
        if (setBatchSize != null) {
            return setBatchSize;
        }
        if (demand > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return Math.max(2, (int)demand);
    }
}

