/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.BsonTimestamp;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.conversions.Bson;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.client.model.Collation;
import com.willfp.eco.libs.mongodb.client.model.changestream.ChangeStreamDocument;
import com.willfp.eco.libs.mongodb.client.model.changestream.FullDocument;
import com.willfp.eco.libs.mongodb.client.model.changestream.FullDocumentBeforeChange;
import com.willfp.eco.libs.mongodb.internal.async.AsyncBatchCursor;
import com.willfp.eco.libs.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncReadOperation;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ClientSession;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.BatchCursorPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import com.willfp.eco.libs.reactivestreams.Publisher;
import java.util.List;
import java.util.concurrent.TimeUnit;

final class ChangeStreamPublisherImpl<T>
extends BatchCursorPublisher<ChangeStreamDocument<T>>
implements ChangeStreamPublisher<T> {
    private final List<? extends Bson> pipeline;
    private final Codec<ChangeStreamDocument<T>> codec;
    private final ChangeStreamLevel changeStreamLevel;
    private FullDocument fullDocument = FullDocument.DEFAULT;
    private FullDocumentBeforeChange fullDocumentBeforeChange = FullDocumentBeforeChange.DEFAULT;
    private BsonDocument resumeToken;
    private BsonDocument startAfter;
    private long maxAwaitTimeMS;
    private Collation collation;
    private BsonValue comment;
    private BsonTimestamp startAtOperationTime;
    private boolean showExpandedEvents;

    ChangeStreamPublisherImpl(@Nullable ClientSession clientSession, MongoOperationPublisher<?> mongoOperationPublisher, Class<T> innerResultClass, List<? extends Bson> pipeline, ChangeStreamLevel changeStreamLevel) {
        this(clientSession, mongoOperationPublisher, ChangeStreamDocument.createCodec(Assertions.notNull("innerResultClass", innerResultClass), mongoOperationPublisher.getCodecRegistry()), Assertions.notNull("pipeline", pipeline), Assertions.notNull("changeStreamLevel", changeStreamLevel));
    }

    private ChangeStreamPublisherImpl(@Nullable ClientSession clientSession, MongoOperationPublisher<?> mongoOperationPublisher, Codec<ChangeStreamDocument<T>> codec, List<? extends Bson> pipeline, ChangeStreamLevel changeStreamLevel) {
        super(clientSession, mongoOperationPublisher.withDocumentClass(codec.getEncoderClass()));
        this.pipeline = pipeline;
        this.codec = codec;
        this.changeStreamLevel = changeStreamLevel;
    }

    @Override
    public ChangeStreamPublisher<T> fullDocument(FullDocument fullDocument) {
        this.fullDocument = Assertions.notNull("fullDocument", fullDocument);
        return this;
    }

    @Override
    public ChangeStreamPublisher<T> fullDocumentBeforeChange(FullDocumentBeforeChange fullDocumentBeforeChange) {
        this.fullDocumentBeforeChange = Assertions.notNull("fullDocumentBeforeChange", fullDocumentBeforeChange);
        return this;
    }

    @Override
    public ChangeStreamPublisher<T> resumeAfter(BsonDocument resumeAfter) {
        this.resumeToken = Assertions.notNull("resumeAfter", resumeAfter);
        return this;
    }

    @Override
    public ChangeStreamPublisher<T> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public ChangeStreamPublisher<T> comment(@Nullable String comment) {
        this.comment = comment == null ? null : new BsonString(comment);
        return this;
    }

    @Override
    public ChangeStreamPublisher<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public ChangeStreamPublisher<T> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public ChangeStreamPublisher<T> collation(@Nullable Collation collation) {
        this.collation = Assertions.notNull("collation", collation);
        return this;
    }

    @Override
    public <TDocument> Publisher<TDocument> withDocumentClass(final Class<TDocument> clazz) {
        return new BatchCursorPublisher<TDocument>(this.getClientSession(), this.getMongoOperationPublisher().withDocumentClass(clazz), this.getBatchSize()){

            @Override
            AsyncReadOperation<AsyncBatchCursor<TDocument>> asAsyncReadOperation(int initialBatchSize) {
                return ChangeStreamPublisherImpl.this.createChangeStreamOperation(this.getMongoOperationPublisher().getCodecRegistry().get(clazz), initialBatchSize);
            }
        };
    }

    @Override
    public ChangeStreamPublisher<T> showExpandedEvents(boolean showExpandedEvents) {
        this.showExpandedEvents = showExpandedEvents;
        return this;
    }

    @Override
    public ChangeStreamPublisher<T> startAtOperationTime(BsonTimestamp startAtOperationTime) {
        this.startAtOperationTime = Assertions.notNull("startAtOperationTime", startAtOperationTime);
        return this;
    }

    @Override
    public ChangeStreamPublisherImpl<T> startAfter(BsonDocument startAfter) {
        this.startAfter = Assertions.notNull("startAfter", startAfter);
        return this;
    }

    @Override
    AsyncReadOperation<AsyncBatchCursor<ChangeStreamDocument<T>>> asAsyncReadOperation(int initialBatchSize) {
        return this.createChangeStreamOperation(this.codec, initialBatchSize);
    }

    private <S> AsyncReadOperation<AsyncBatchCursor<S>> createChangeStreamOperation(Codec<S> codec, int initialBatchSize) {
        return this.getOperations().changeStream(this.fullDocument, this.fullDocumentBeforeChange, this.pipeline, codec, this.changeStreamLevel, initialBatchSize, this.collation, this.comment, this.maxAwaitTimeMS, this.resumeToken, this.startAtOperationTime, this.startAfter, this.showExpandedEvents);
    }
}

