/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal;

import com.willfp.eco.libs.mongodb.ClientSessionOptions;
import com.willfp.eco.libs.mongodb.TransactionOptions;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.internal.session.ServerSessionPool;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ClientSession;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.ClientSessionPublisherImpl;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.MongoClientImpl;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.OperationExecutor;
import com.willfp.eco.libs.reactor.core.publisher.Mono;

public class ClientSessionHelper {
    private final MongoClientImpl mongoClient;
    private final ServerSessionPool serverSessionPool;

    public ClientSessionHelper(MongoClientImpl mongoClient, ServerSessionPool serverSessionPool) {
        this.mongoClient = mongoClient;
        this.serverSessionPool = serverSessionPool;
    }

    Mono<ClientSession> withClientSession(@Nullable ClientSession clientSessionFromOperation, OperationExecutor executor) {
        if (clientSessionFromOperation != null) {
            Assertions.isTrue("ClientSession from same MongoClient", clientSessionFromOperation.getOriginator() == this.mongoClient);
            return Mono.fromCallable(() -> clientSessionFromOperation);
        }
        return this.createClientSessionMono(ClientSessionOptions.builder().causallyConsistent(false).build(), executor);
    }

    Mono<ClientSession> createClientSessionMono(ClientSessionOptions options2, OperationExecutor executor) {
        return Mono.fromCallable(() -> this.createClientSession(options2, executor));
    }

    ClientSession createClientSession(ClientSessionOptions options2, OperationExecutor executor) {
        ClientSessionOptions mergedOptions = ClientSessionOptions.builder(options2).defaultTransactionOptions(TransactionOptions.merge(options2.getDefaultTransactionOptions(), TransactionOptions.builder().readConcern(this.mongoClient.getSettings().getReadConcern()).writeConcern(this.mongoClient.getSettings().getWriteConcern()).readPreference(this.mongoClient.getSettings().getReadPreference()).build())).build();
        return new ClientSessionPublisherImpl(this.serverSessionPool, this.mongoClient, mergedOptions, executor);
    }
}

