/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal;

import com.willfp.eco.libs.mongodb.ClientSessionOptions;
import com.willfp.eco.libs.mongodb.MongoClientException;
import com.willfp.eco.libs.mongodb.MongoException;
import com.willfp.eco.libs.mongodb.MongoInternalException;
import com.willfp.eco.libs.mongodb.ReadConcern;
import com.willfp.eco.libs.mongodb.TransactionOptions;
import com.willfp.eco.libs.mongodb.WriteConcern;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.internal.operation.AbortTransactionOperation;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncReadOperation;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncWriteOperation;
import com.willfp.eco.libs.mongodb.internal.operation.CommitTransactionOperation;
import com.willfp.eco.libs.mongodb.internal.session.BaseClientSessionImpl;
import com.willfp.eco.libs.mongodb.internal.session.ServerSessionPool;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ClientSession;
import com.willfp.eco.libs.mongodb.reactivestreams.client.MongoClient;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.OperationExecutor;
import com.willfp.eco.libs.reactivestreams.Publisher;
import com.willfp.eco.libs.reactor.core.publisher.Mono;
import com.willfp.eco.libs.reactor.core.publisher.MonoSink;
import java.util.concurrent.TimeUnit;

final class ClientSessionPublisherImpl
extends BaseClientSessionImpl
implements ClientSession {
    private final OperationExecutor executor;
    private TransactionState transactionState = TransactionState.NONE;
    private boolean messageSentInCurrentTransaction;
    private boolean commitInProgress;
    private TransactionOptions transactionOptions;

    ClientSessionPublisherImpl(ServerSessionPool serverSessionPool, MongoClient mongoClient, ClientSessionOptions options2, OperationExecutor executor) {
        super(serverSessionPool, mongoClient, options2);
        this.executor = executor;
    }

    @Override
    public boolean hasActiveTransaction() {
        return this.transactionState == TransactionState.IN || this.transactionState == TransactionState.COMMITTED && this.commitInProgress;
    }

    @Override
    public boolean notifyMessageSent() {
        if (this.hasActiveTransaction()) {
            boolean firstMessageInCurrentTransaction = !this.messageSentInCurrentTransaction;
            this.messageSentInCurrentTransaction = true;
            return firstMessageInCurrentTransaction;
        }
        if (this.transactionState == TransactionState.COMMITTED || this.transactionState == TransactionState.ABORTED) {
            this.cleanupTransaction(TransactionState.NONE);
        }
        return false;
    }

    @Override
    public void notifyOperationInitiated(Object operation) {
        Assertions.assertTrue(operation instanceof AsyncReadOperation || operation instanceof AsyncWriteOperation);
        if (!this.hasActiveTransaction() && !(operation instanceof CommitTransactionOperation)) {
            Assertions.assertTrue(this.getPinnedServerAddress() == null || this.transactionState != TransactionState.ABORTED && this.transactionState != TransactionState.NONE);
            this.clearTransactionContext();
        }
    }

    @Override
    public TransactionOptions getTransactionOptions() {
        Assertions.isTrue("in transaction", this.transactionState == TransactionState.IN || this.transactionState == TransactionState.COMMITTED);
        return this.transactionOptions;
    }

    @Override
    public void startTransaction() {
        this.startTransaction(TransactionOptions.builder().build());
    }

    @Override
    public void startTransaction(TransactionOptions transactionOptions) {
        Assertions.notNull("transactionOptions", transactionOptions);
        Boolean snapshot = this.getOptions().isSnapshot();
        if (snapshot != null && snapshot.booleanValue()) {
            throw new IllegalArgumentException("Transactions are not supported in snapshot sessions");
        }
        if (this.transactionState == TransactionState.IN) {
            throw new IllegalStateException("Transaction already in progress");
        }
        if (this.transactionState == TransactionState.COMMITTED) {
            this.cleanupTransaction(TransactionState.IN);
        } else {
            this.transactionState = TransactionState.IN;
        }
        this.getServerSession().advanceTransactionNumber();
        this.transactionOptions = TransactionOptions.merge(transactionOptions, this.getOptions().getDefaultTransactionOptions());
        WriteConcern writeConcern = this.transactionOptions.getWriteConcern();
        if (writeConcern == null) {
            throw new MongoInternalException("Invariant violated. Transaction options write concern can not be null");
        }
        if (!writeConcern.isAcknowledged()) {
            throw new MongoClientException("Transactions do not support unacknowledged write concern");
        }
        this.clearTransactionContext();
    }

    @Override
    public Publisher<Void> commitTransaction() {
        if (this.transactionState == TransactionState.ABORTED) {
            throw new IllegalStateException("Cannot call commitTransaction after calling abortTransaction");
        }
        if (this.transactionState == TransactionState.NONE) {
            throw new IllegalStateException("There is no transaction started");
        }
        if (!this.messageSentInCurrentTransaction) {
            this.cleanupTransaction(TransactionState.COMMITTED);
            return Mono.create(MonoSink::success);
        }
        ReadConcern readConcern = this.transactionOptions.getReadConcern();
        if (readConcern == null) {
            throw new MongoInternalException("Invariant violated. Transaction options read concern can not be null");
        }
        boolean alreadyCommitted = this.commitInProgress || this.transactionState == TransactionState.COMMITTED;
        this.commitInProgress = true;
        return this.executor.execute(new CommitTransactionOperation(Assertions.assertNotNull(this.transactionOptions.getWriteConcern()), alreadyCommitted).recoveryToken(this.getRecoveryToken()).maxCommitTime(this.transactionOptions.getMaxCommitTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS), readConcern, this).doOnTerminate(() -> {
            this.commitInProgress = false;
            this.transactionState = TransactionState.COMMITTED;
        }).doOnError(MongoException.class, this::clearTransactionContextOnError);
    }

    @Override
    public Publisher<Void> abortTransaction() {
        if (this.transactionState == TransactionState.ABORTED) {
            throw new IllegalStateException("Cannot call abortTransaction twice");
        }
        if (this.transactionState == TransactionState.COMMITTED) {
            throw new IllegalStateException("Cannot call abortTransaction after calling commitTransaction");
        }
        if (this.transactionState == TransactionState.NONE) {
            throw new IllegalStateException("There is no transaction started");
        }
        if (!this.messageSentInCurrentTransaction) {
            this.cleanupTransaction(TransactionState.ABORTED);
            return Mono.create(MonoSink::success);
        }
        ReadConcern readConcern = this.transactionOptions.getReadConcern();
        if (readConcern == null) {
            throw new MongoInternalException("Invariant violated. Transaction options read concern can not be null");
        }
        return this.executor.execute(new AbortTransactionOperation(Assertions.assertNotNull(this.transactionOptions.getWriteConcern())).recoveryToken(this.getRecoveryToken()), readConcern, this).onErrorResume(Throwable.class, e -> Mono.empty()).doOnTerminate(() -> {
            this.clearTransactionContext();
            this.cleanupTransaction(TransactionState.ABORTED);
        });
    }

    private void clearTransactionContextOnError(MongoException e) {
        if (e.hasErrorLabel("TransientTransactionError") || e.hasErrorLabel("UnknownTransactionCommitResult")) {
            this.clearTransactionContext();
        }
    }

    @Override
    public void close() {
        if (this.transactionState == TransactionState.IN) {
            Mono.from(this.abortTransaction()).doOnSuccess(it -> this.close()).subscribe();
        } else {
            super.close();
        }
    }

    private void cleanupTransaction(TransactionState nextState) {
        this.messageSentInCurrentTransaction = false;
        this.transactionOptions = null;
        this.transactionState = nextState;
    }

    private static enum TransactionState {
        NONE,
        IN,
        COMMITTED,
        ABORTED;

    }
}

