/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal;

import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.Document;
import com.willfp.eco.libs.bson.conversions.Bson;
import com.willfp.eco.libs.mongodb.CursorType;
import com.willfp.eco.libs.mongodb.ExplainVerbosity;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.client.model.Collation;
import com.willfp.eco.libs.mongodb.internal.async.AsyncBatchCursor;
import com.willfp.eco.libs.mongodb.internal.client.model.FindOptions;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncExplainableReadOperation;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncReadOperation;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ClientSession;
import com.willfp.eco.libs.mongodb.reactivestreams.client.FindPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.BatchCursorPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import com.willfp.eco.libs.reactivestreams.Publisher;
import java.util.concurrent.TimeUnit;

final class FindPublisherImpl<T>
extends BatchCursorPublisher<T>
implements FindPublisher<T> {
    private final FindOptions findOptions;
    private Bson filter;

    FindPublisherImpl(@Nullable ClientSession clientSession, MongoOperationPublisher<T> mongoOperationPublisher, Bson filter2) {
        super(clientSession, mongoOperationPublisher);
        this.filter = Assertions.notNull("filter", filter2);
        this.findOptions = new FindOptions();
    }

    @Override
    public FindPublisher<T> filter(@Nullable Bson filter2) {
        this.filter = filter2;
        return this;
    }

    @Override
    public FindPublisher<T> limit(int limit) {
        this.findOptions.limit(limit);
        return this;
    }

    @Override
    public FindPublisher<T> skip(int skip) {
        this.findOptions.skip(skip);
        return this;
    }

    @Override
    public FindPublisher<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.findOptions.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public FindPublisher<T> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.findOptions.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public FindPublisher<T> batchSize(int batchSize) {
        super.batchSize(batchSize);
        this.findOptions.batchSize(batchSize);
        return this;
    }

    @Override
    public FindPublisher<T> collation(@Nullable Collation collation) {
        this.findOptions.collation(collation);
        return this;
    }

    @Override
    public FindPublisher<T> projection(@Nullable Bson projection2) {
        this.findOptions.projection(projection2);
        return this;
    }

    @Override
    public FindPublisher<T> sort(@Nullable Bson sort) {
        this.findOptions.sort(sort);
        return this;
    }

    @Override
    public FindPublisher<T> noCursorTimeout(boolean noCursorTimeout) {
        this.findOptions.noCursorTimeout(noCursorTimeout);
        return this;
    }

    @Override
    @Deprecated
    public FindPublisher<T> oplogReplay(boolean oplogReplay) {
        this.findOptions.oplogReplay(oplogReplay);
        return this;
    }

    @Override
    public FindPublisher<T> partial(boolean partial) {
        this.findOptions.partial(partial);
        return this;
    }

    @Override
    public FindPublisher<T> cursorType(CursorType cursorType) {
        this.findOptions.cursorType(cursorType);
        return this;
    }

    @Override
    public FindPublisher<T> comment(@Nullable String comment) {
        this.findOptions.comment(comment);
        return this;
    }

    @Override
    public FindPublisher<T> comment(@Nullable BsonValue comment) {
        this.findOptions.comment(comment);
        return this;
    }

    @Override
    public FindPublisher<T> hint(@Nullable Bson hint) {
        this.findOptions.hint(hint);
        return this;
    }

    @Override
    public FindPublisher<T> hintString(@Nullable String hint) {
        this.findOptions.hintString(hint);
        return this;
    }

    @Override
    public FindPublisher<T> let(@Nullable Bson variables) {
        this.findOptions.let(variables);
        return this;
    }

    @Override
    public FindPublisher<T> max(@Nullable Bson max) {
        this.findOptions.max(max);
        return this;
    }

    @Override
    public FindPublisher<T> min(@Nullable Bson min2) {
        this.findOptions.min(min2);
        return this;
    }

    @Override
    public FindPublisher<T> returnKey(boolean returnKey) {
        this.findOptions.returnKey(returnKey);
        return this;
    }

    @Override
    public FindPublisher<T> showRecordId(boolean showRecordId) {
        this.findOptions.showRecordId(showRecordId);
        return this;
    }

    @Override
    public FindPublisher<T> allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.findOptions.allowDiskUse(allowDiskUse);
        return this;
    }

    @Override
    public Publisher<Document> explain() {
        return this.publishExplain(Document.class, null);
    }

    @Override
    public Publisher<Document> explain(ExplainVerbosity verbosity) {
        return this.publishExplain(Document.class, Assertions.notNull("verbosity", verbosity));
    }

    @Override
    public <E> Publisher<E> explain(Class<E> explainResultClass) {
        return this.publishExplain(explainResultClass, null);
    }

    @Override
    public <E> Publisher<E> explain(Class<E> explainResultClass, ExplainVerbosity verbosity) {
        return this.publishExplain(explainResultClass, Assertions.notNull("verbosity", verbosity));
    }

    private <E> Publisher<E> publishExplain(Class<E> explainResultClass, @Nullable ExplainVerbosity verbosity) {
        Assertions.notNull("explainDocumentClass", explainResultClass);
        return this.getMongoOperationPublisher().createReadOperationMono(() -> this.asAsyncReadOperation(0).asAsyncExplainableOperation(verbosity, this.getCodecRegistry().get(explainResultClass)), this.getClientSession());
    }

    @Override
    AsyncExplainableReadOperation<AsyncBatchCursor<T>> asAsyncReadOperation(int initialBatchSize) {
        return this.getOperations().find(this.filter, this.getDocumentClass(), this.findOptions.withBatchSize(initialBatchSize));
    }

    @Override
    AsyncReadOperation<AsyncBatchCursor<T>> asAsyncFirstReadOperation() {
        return this.getOperations().findFirst(this.filter, this.getDocumentClass(), this.findOptions);
    }
}

