/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal;

import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.conversions.Bson;
import com.willfp.eco.libs.mongodb.ReadConcern;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.internal.async.AsyncBatchCursor;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncReadOperation;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ClientSession;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ListCollectionsPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.BatchCursorPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import java.util.concurrent.TimeUnit;

final class ListCollectionsPublisherImpl<T>
extends BatchCursorPublisher<T>
implements ListCollectionsPublisher<T> {
    private final boolean collectionNamesOnly;
    private Bson filter;
    private long maxTimeMS;
    private BsonValue comment;

    ListCollectionsPublisherImpl(@Nullable ClientSession clientSession, MongoOperationPublisher<T> mongoOperationPublisher, boolean collectionNamesOnly) {
        super(clientSession, mongoOperationPublisher.withReadConcern(ReadConcern.DEFAULT));
        this.collectionNamesOnly = collectionNamesOnly;
    }

    @Override
    public ListCollectionsPublisher<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListCollectionsPublisher<T> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public ListCollectionsPublisher<T> filter(@Nullable Bson filter2) {
        this.filter = filter2;
        return this;
    }

    @Override
    public ListCollectionsPublisher<T> comment(@Nullable String comment) {
        this.comment = comment != null ? new BsonString(comment) : null;
        return this;
    }

    @Override
    public ListCollectionsPublisher<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    AsyncReadOperation<AsyncBatchCursor<T>> asAsyncReadOperation(int initialBatchSize) {
        return this.getOperations().listCollections(this.getNamespace().getDatabaseName(), this.getDocumentClass(), this.filter, this.collectionNamesOnly, initialBatchSize, this.maxTimeMS, this.comment);
    }
}

