/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal;

import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.internal.async.AsyncBatchCursor;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncReadOperation;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ClientSession;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ListIndexesPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.BatchCursorPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import java.util.concurrent.TimeUnit;

final class ListIndexesPublisherImpl<T>
extends BatchCursorPublisher<T>
implements ListIndexesPublisher<T> {
    private long maxTimeMS;
    private BsonValue comment;

    ListIndexesPublisherImpl(@Nullable ClientSession clientSession, MongoOperationPublisher<T> mongoOperationPublisher) {
        super(clientSession, mongoOperationPublisher);
    }

    @Override
    public ListIndexesPublisher<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListIndexesPublisher<T> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public ListIndexesPublisher<T> comment(@Nullable String comment) {
        this.comment = comment != null ? new BsonString(comment) : null;
        return this;
    }

    @Override
    public ListIndexesPublisher<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    AsyncReadOperation<AsyncBatchCursor<T>> asAsyncReadOperation(int initialBatchSize) {
        return this.getOperations().listIndexes(this.getDocumentClass(), initialBatchSize, this.maxTimeMS, this.comment);
    }
}

