/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal;

import com.willfp.eco.libs.mongodb.ContextProvider;
import com.willfp.eco.libs.mongodb.MongoClientException;
import com.willfp.eco.libs.mongodb.MongoException;
import com.willfp.eco.libs.mongodb.MongoInternalException;
import com.willfp.eco.libs.mongodb.MongoQueryException;
import com.willfp.eco.libs.mongodb.MongoSocketException;
import com.willfp.eco.libs.mongodb.MongoTimeoutException;
import com.willfp.eco.libs.mongodb.ReadConcern;
import com.willfp.eco.libs.mongodb.ReadPreference;
import com.willfp.eco.libs.mongodb.RequestContext;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.internal.IgnorableRequestContext;
import com.willfp.eco.libs.mongodb.internal.binding.AsyncClusterAwareReadWriteBinding;
import com.willfp.eco.libs.mongodb.internal.binding.AsyncClusterBinding;
import com.willfp.eco.libs.mongodb.internal.binding.AsyncReadBinding;
import com.willfp.eco.libs.mongodb.internal.binding.AsyncReadWriteBinding;
import com.willfp.eco.libs.mongodb.internal.binding.AsyncWriteBinding;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncReadOperation;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncWriteOperation;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ClientSession;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ReactiveContextProvider;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.ClientSessionBinding;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.ClientSessionHelper;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.MongoClientImpl;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.OperationExecutor;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.crypt.Crypt;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.crypt.CryptBinding;
import com.willfp.eco.libs.reactivestreams.Subscriber;
import com.willfp.eco.libs.reactor.core.publisher.Mono;

public class OperationExecutorImpl
implements OperationExecutor {
    private final MongoClientImpl mongoClient;
    private final ClientSessionHelper clientSessionHelper;
    private final ReactiveContextProvider contextProvider;

    OperationExecutorImpl(MongoClientImpl mongoClient, ClientSessionHelper clientSessionHelper) {
        this.mongoClient = mongoClient;
        this.clientSessionHelper = clientSessionHelper;
        ContextProvider contextProvider = mongoClient.getSettings().getContextProvider();
        if (contextProvider != null && !(contextProvider instanceof ReactiveContextProvider)) {
            throw new IllegalArgumentException("The contextProvider must be an instance of " + ReactiveContextProvider.class.getName() + " when using the Reactive Streams driver");
        }
        this.contextProvider = (ReactiveContextProvider)contextProvider;
    }

    @Override
    public <T> Mono<T> execute(AsyncReadOperation<T> operation, ReadPreference readPreference, ReadConcern readConcern, @Nullable ClientSession session) {
        Assertions.notNull("operation", operation);
        Assertions.notNull("readPreference", readPreference);
        Assertions.notNull("readConcern", readConcern);
        if (session != null) {
            session.notifyOperationInitiated(operation);
        }
        return Mono.from(subscriber -> this.clientSessionHelper.withClientSession(session, this).map(clientSession -> this.getReadWriteBinding(this.getContext(subscriber), readPreference, readConcern, (ClientSession)clientSession, session == null && clientSession != null)).switchIfEmpty(Mono.fromCallable(() -> this.getReadWriteBinding(this.getContext(subscriber), readPreference, readConcern, session, false))).flatMap(binding -> {
            if (session != null && session.hasActiveTransaction() && !binding.getReadPreference().equals(ReadPreference.primary())) {
                binding.release();
                return Mono.error(new MongoClientException("Read preference in a transaction must be primary"));
            }
            return Mono.create(sink -> operation.executeAsync((AsyncReadBinding)binding, (result2, t2) -> {
                try {
                    binding.release();
                }
                finally {
                    MongoOperationPublisher.sinkToCallback(sink).onResult(result2, t2);
                }
            })).doOnError(t2 -> {
                this.labelException(session, (Throwable)t2);
                this.unpinServerAddressOnTransientTransactionError(session, (Throwable)t2);
            });
        }).subscribe(subscriber));
    }

    @Override
    public <T> Mono<T> execute(AsyncWriteOperation<T> operation, ReadConcern readConcern, @Nullable ClientSession session) {
        Assertions.notNull("operation", operation);
        Assertions.notNull("readConcern", readConcern);
        if (session != null) {
            session.notifyOperationInitiated(operation);
        }
        return Mono.from(subscriber -> this.clientSessionHelper.withClientSession(session, this).map(clientSession -> this.getReadWriteBinding(this.getContext(subscriber), ReadPreference.primary(), readConcern, (ClientSession)clientSession, session == null && clientSession != null)).switchIfEmpty(Mono.fromCallable(() -> this.getReadWriteBinding(this.getContext(subscriber), ReadPreference.primary(), readConcern, session, false))).flatMap(binding -> Mono.create(sink -> operation.executeAsync((AsyncWriteBinding)binding, (result2, t2) -> {
            try {
                binding.release();
            }
            finally {
                MongoOperationPublisher.sinkToCallback(sink).onResult(result2, t2);
            }
        })).doOnError(t2 -> {
            this.labelException(session, (Throwable)t2);
            this.unpinServerAddressOnTransientTransactionError(session, (Throwable)t2);
        })).subscribe(subscriber));
    }

    private <T> RequestContext getContext(Subscriber<T> subscriber) {
        RequestContext context = null;
        if (this.contextProvider != null) {
            context = this.contextProvider.getContext(subscriber);
        }
        return context == null ? IgnorableRequestContext.INSTANCE : context;
    }

    private void labelException(@Nullable ClientSession session, @Nullable Throwable t2) {
        if (session != null && session.hasActiveTransaction() && (t2 instanceof MongoSocketException || t2 instanceof MongoTimeoutException || t2 instanceof MongoQueryException && ((MongoQueryException)t2).getErrorCode() == 91) && !((MongoException)t2).hasErrorLabel("UnknownTransactionCommitResult")) {
            ((MongoException)t2).addLabel("TransientTransactionError");
        }
    }

    private void unpinServerAddressOnTransientTransactionError(@Nullable ClientSession session, @Nullable Throwable throwable) {
        if (session != null && throwable instanceof MongoException && ((MongoException)throwable).hasErrorLabel("TransientTransactionError")) {
            session.clearTransactionContext();
        }
    }

    private AsyncReadWriteBinding getReadWriteBinding(RequestContext requestContext, ReadPreference readPreference, ReadConcern readConcern, @Nullable ClientSession session, boolean ownsSession) {
        Assertions.notNull("readPreference", readPreference);
        AsyncClusterAwareReadWriteBinding readWriteBinding = new AsyncClusterBinding(this.mongoClient.getCluster(), this.getReadPreferenceForBinding(readPreference, session), readConcern, this.mongoClient.getSettings().getServerApi(), requestContext);
        Crypt crypt = this.mongoClient.getCrypt();
        if (crypt != null) {
            readWriteBinding = new CryptBinding(readWriteBinding, crypt);
        }
        AsyncClusterBinding asyncReadWriteBinding = readWriteBinding;
        if (session != null) {
            return new ClientSessionBinding(session, ownsSession, asyncReadWriteBinding);
        }
        return asyncReadWriteBinding;
    }

    private ReadPreference getReadPreferenceForBinding(ReadPreference readPreference, @Nullable ClientSession session) {
        if (session == null) {
            return readPreference;
        }
        if (session.hasActiveTransaction()) {
            ReadPreference readPreferenceForBinding = session.getTransactionOptions().getReadPreference();
            if (readPreferenceForBinding == null) {
                throw new MongoInternalException("Invariant violated.  Transaction options read preference can not be null");
            }
            return readPreferenceForBinding;
        }
        return readPreference;
    }
}

