/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal.crypt;

import com.willfp.eco.libs.bson.BsonBinary;
import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.RawBsonDocument;
import com.willfp.eco.libs.mongodb.MongoClientException;
import com.willfp.eco.libs.mongodb.MongoException;
import com.willfp.eco.libs.mongodb.MongoInternalException;
import com.willfp.eco.libs.mongodb.annotations.Beta;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.client.model.vault.DataKeyOptions;
import com.willfp.eco.libs.mongodb.client.model.vault.EncryptOptions;
import com.willfp.eco.libs.mongodb.client.model.vault.RewrapManyDataKeyOptions;
import com.willfp.eco.libs.mongodb.crypt.capi.MongoCrypt;
import com.willfp.eco.libs.mongodb.crypt.capi.MongoCryptContext;
import com.willfp.eco.libs.mongodb.crypt.capi.MongoCryptException;
import com.willfp.eco.libs.mongodb.crypt.capi.MongoDataKeyOptions;
import com.willfp.eco.libs.mongodb.crypt.capi.MongoKeyDecryptor;
import com.willfp.eco.libs.mongodb.crypt.capi.MongoRewrapManyDataKeyOptions;
import com.willfp.eco.libs.mongodb.internal.capi.MongoCryptHelper;
import com.willfp.eco.libs.mongodb.internal.client.vault.EncryptOptionsHelper;
import com.willfp.eco.libs.mongodb.internal.diagnostics.logging.Logger;
import com.willfp.eco.libs.mongodb.internal.diagnostics.logging.Loggers;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.reactivestreams.client.MongoClient;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.crypt.CollectionInfoRetriever;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.crypt.CommandMarker;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.crypt.KeyManagementService;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.crypt.KeyRetriever;
import com.willfp.eco.libs.reactor.core.publisher.Mono;
import com.willfp.eco.libs.reactor.core.publisher.MonoSink;
import java.io.Closeable;
import java.util.Map;
import java.util.function.Supplier;

public class Crypt
implements Closeable {
    private static final RawBsonDocument EMPTY_RAW_BSON_DOCUMENT = RawBsonDocument.parse("{}");
    private static final Logger LOGGER = Loggers.getLogger("client");
    private final MongoCrypt mongoCrypt;
    private final Map<String, Map<String, Object>> kmsProviders;
    private final Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers;
    private final CollectionInfoRetriever collectionInfoRetriever;
    private final CommandMarker commandMarker;
    private final KeyRetriever keyRetriever;
    private final KeyManagementService keyManagementService;
    private final boolean bypassAutoEncryption;
    @Nullable
    private final MongoClient collectionInfoRetrieverClient;
    @Nullable
    private final MongoClient keyVaultClient;

    Crypt(MongoCrypt mongoCrypt, KeyRetriever keyRetriever, KeyManagementService keyManagementService, Map<String, Map<String, Object>> kmsProviders, Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers) {
        this(mongoCrypt, keyRetriever, keyManagementService, kmsProviders, kmsProviderPropertySuppliers, false, null, null, null, null);
    }

    Crypt(MongoCrypt mongoCrypt, KeyRetriever keyRetriever, KeyManagementService keyManagementService, Map<String, Map<String, Object>> kmsProviders, Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers, boolean bypassAutoEncryption, @Nullable CollectionInfoRetriever collectionInfoRetriever, @Nullable CommandMarker commandMarker, @Nullable MongoClient collectionInfoRetrieverClient, @Nullable MongoClient keyVaultClient) {
        this.mongoCrypt = mongoCrypt;
        this.keyRetriever = keyRetriever;
        this.keyManagementService = keyManagementService;
        this.kmsProviders = kmsProviders;
        this.kmsProviderPropertySuppliers = kmsProviderPropertySuppliers;
        this.bypassAutoEncryption = bypassAutoEncryption;
        this.collectionInfoRetriever = collectionInfoRetriever;
        this.commandMarker = commandMarker;
        this.collectionInfoRetrieverClient = collectionInfoRetrieverClient;
        this.keyVaultClient = keyVaultClient;
    }

    public Mono<RawBsonDocument> encrypt(String databaseName, RawBsonDocument command2) {
        Assertions.notNull("databaseName", databaseName);
        Assertions.notNull("command", command2);
        if (this.bypassAutoEncryption) {
            return Mono.fromCallable(() -> command2);
        }
        return this.executeStateMachine(() -> this.mongoCrypt.createEncryptionContext(databaseName, (BsonDocument)command2), databaseName);
    }

    public Mono<RawBsonDocument> decrypt(RawBsonDocument commandResponse) {
        Assertions.notNull("commandResponse", commandResponse);
        return this.executeStateMachine(() -> this.mongoCrypt.createDecryptionContext((BsonDocument)commandResponse)).onErrorMap(this::wrapInClientException);
    }

    public Mono<RawBsonDocument> createDataKey(String kmsProvider, DataKeyOptions options2) {
        Assertions.notNull("kmsProvider", kmsProvider);
        Assertions.notNull("options", options2);
        return this.executeStateMachine(() -> this.mongoCrypt.createDataKeyContext(kmsProvider, MongoDataKeyOptions.builder().keyAltNames(options2.getKeyAltNames()).masterKey(options2.getMasterKey()).keyMaterial(options2.getKeyMaterial()).build()));
    }

    public Mono<BsonBinary> encryptExplicitly(BsonValue value, EncryptOptions options2) {
        Assertions.notNull("value", value);
        Assertions.notNull("options", options2);
        return this.executeStateMachine(() -> this.mongoCrypt.createExplicitEncryptionContext(new BsonDocument("v", value), EncryptOptionsHelper.asMongoExplicitEncryptOptions(options2))).map(result2 -> result2.getBinary("v"));
    }

    @Beta(value={Beta.Reason.SERVER})
    public Mono<BsonDocument> encryptExpression(BsonDocument expression, EncryptOptions options2) {
        return this.executeStateMachine(() -> this.mongoCrypt.createEncryptExpressionContext(new BsonDocument("v", expression), EncryptOptionsHelper.asMongoExplicitEncryptOptions(options2))).map(result2 -> result2.getDocument("v"));
    }

    public Mono<BsonValue> decryptExplicitly(BsonBinary value) {
        Assertions.notNull("value", value);
        return this.executeStateMachine(() -> this.mongoCrypt.createExplicitDecryptionContext(new BsonDocument("v", value))).map(result2 -> result2.get("v"));
    }

    public Mono<RawBsonDocument> rewrapManyDataKey(BsonDocument filter2, RewrapManyDataKeyOptions options2) {
        return this.executeStateMachine(() -> this.mongoCrypt.createRewrapManyDatakeyContext(filter2, MongoRewrapManyDataKeyOptions.builder().provider(options2.getProvider()).masterKey(options2.getMasterKey()).build()));
    }

    @Override
    public void close() {
        try (MongoCrypt ignored = this.mongoCrypt;
             CommandMarker ignored1 = this.commandMarker;
             MongoClient ignored2 = this.collectionInfoRetrieverClient;
             MongoClient ignored3 = this.keyVaultClient;){
            KeyManagementService ignored4 = this.keyManagementService;
            if (ignored4 != null) {
                ignored4.close();
            }
        }
    }

    private Mono<RawBsonDocument> executeStateMachine(Supplier<MongoCryptContext> cryptContextSupplier) {
        return this.executeStateMachine(cryptContextSupplier, null);
    }

    private Mono<RawBsonDocument> executeStateMachine(Supplier<MongoCryptContext> cryptContextSupplier, @Nullable String databaseName) {
        try {
            MongoCryptContext cryptContext = cryptContextSupplier.get();
            return Mono.create(sink -> this.executeStateMachineWithSink(cryptContext, databaseName, (MonoSink<RawBsonDocument>)sink)).onErrorMap(this::wrapInClientException).doFinally(s2 -> cryptContext.close());
        }
        catch (MongoCryptException e) {
            return Mono.error(this.wrapInClientException(e));
        }
    }

    private void executeStateMachineWithSink(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink) {
        MongoCryptContext.State state = cryptContext.getState();
        switch (state) {
            case NEED_MONGO_COLLINFO: {
                this.collInfo(cryptContext, databaseName, sink);
                break;
            }
            case NEED_MONGO_MARKINGS: {
                this.mark(cryptContext, databaseName, sink);
                break;
            }
            case NEED_KMS_CREDENTIALS: {
                this.fetchCredentials(cryptContext, databaseName, sink);
                break;
            }
            case NEED_MONGO_KEYS: {
                this.fetchKeys(cryptContext, databaseName, sink);
                break;
            }
            case NEED_KMS: {
                this.decryptKeys(cryptContext, databaseName, sink);
                break;
            }
            case READY: {
                sink.success(cryptContext.finish());
                break;
            }
            case DONE: {
                sink.success(EMPTY_RAW_BSON_DOCUMENT);
                break;
            }
            default: {
                sink.error(new MongoInternalException("Unsupported encryptor state + " + state));
            }
        }
    }

    private void fetchCredentials(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink) {
        try {
            cryptContext.provideKmsProviderCredentials(MongoCryptHelper.fetchCredentials(this.kmsProviders, this.kmsProviderPropertySuppliers));
            this.executeStateMachineWithSink(cryptContext, databaseName, sink);
        }
        catch (Exception e) {
            sink.error(e);
        }
    }

    private void collInfo(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink) {
        if (this.collectionInfoRetriever == null) {
            sink.error(new IllegalStateException("Missing collection Info retriever"));
        } else if (databaseName == null) {
            sink.error(new IllegalStateException("Missing database name"));
        } else {
            this.collectionInfoRetriever.filter(databaseName, cryptContext.getMongoOperation()).doOnSuccess(result2 -> {
                if (result2 != null) {
                    cryptContext.addMongoOperationResult(result2);
                }
                cryptContext.completeMongoOperation();
                this.executeStateMachineWithSink(cryptContext, databaseName, sink);
            }).doOnError(t2 -> sink.error(MongoException.fromThrowableNonNull(t2))).subscribe();
        }
    }

    private void mark(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink) {
        if (this.commandMarker == null) {
            sink.error(this.wrapInClientException(new MongoInternalException("Missing command marker")));
        } else if (databaseName == null) {
            sink.error(this.wrapInClientException(new IllegalStateException("Missing database name")));
        } else {
            this.commandMarker.mark(databaseName, cryptContext.getMongoOperation()).doOnSuccess(result2 -> {
                cryptContext.addMongoOperationResult((BsonDocument)result2);
                cryptContext.completeMongoOperation();
                this.executeStateMachineWithSink(cryptContext, databaseName, sink);
            }).doOnError(e -> sink.error(this.wrapInClientException((Throwable)e))).subscribe();
        }
    }

    private void fetchKeys(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink) {
        this.keyRetriever.find(cryptContext.getMongoOperation()).doOnSuccess(results -> {
            for (BsonDocument result2 : results) {
                cryptContext.addMongoOperationResult(result2);
            }
            cryptContext.completeMongoOperation();
            this.executeStateMachineWithSink(cryptContext, databaseName, sink);
        }).doOnError(t2 -> sink.error(MongoException.fromThrowableNonNull(t2))).subscribe();
    }

    private void decryptKeys(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink) {
        MongoKeyDecryptor keyDecryptor = cryptContext.nextKeyDecryptor();
        if (keyDecryptor != null) {
            this.keyManagementService.decryptKey(keyDecryptor).doOnSuccess(r -> this.decryptKeys(cryptContext, databaseName, sink)).doOnError(e -> sink.error(this.wrapInClientException((Throwable)e))).subscribe();
        } else {
            Mono.fromRunnable(() -> ((MongoCryptContext)cryptContext).completeKeyDecryptors()).doOnSuccess(r -> this.executeStateMachineWithSink(cryptContext, databaseName, sink)).doOnError(e -> sink.error(this.wrapInClientException((Throwable)e))).subscribe();
        }
    }

    private Throwable wrapInClientException(Throwable t2) {
        if (t2 instanceof MongoClientException) {
            return t2;
        }
        return new MongoClientException("Exception in encryption library: " + t2.getMessage(), t2);
    }
}

