/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal.crypt;

import com.willfp.eco.libs.bson.BsonBinaryReader;
import com.willfp.eco.libs.bson.BsonBinaryWriter;
import com.willfp.eco.libs.bson.BsonBinaryWriterSettings;
import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonWriter;
import com.willfp.eco.libs.bson.BsonWriterSettings;
import com.willfp.eco.libs.bson.FieldNameValidator;
import com.willfp.eco.libs.bson.RawBsonDocument;
import com.willfp.eco.libs.bson.codecs.BsonValueCodecProvider;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.Decoder;
import com.willfp.eco.libs.bson.codecs.DecoderContext;
import com.willfp.eco.libs.bson.codecs.EncoderContext;
import com.willfp.eco.libs.bson.codecs.RawBsonDocumentCodec;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistries;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import com.willfp.eco.libs.bson.io.BasicOutputBuffer;
import com.willfp.eco.libs.bson.io.BsonOutput;
import com.willfp.eco.libs.mongodb.MongoClientException;
import com.willfp.eco.libs.mongodb.ReadPreference;
import com.willfp.eco.libs.mongodb.connection.ConnectionDescription;
import com.willfp.eco.libs.mongodb.internal.async.SingleResultCallback;
import com.willfp.eco.libs.mongodb.internal.binding.BindingContext;
import com.willfp.eco.libs.mongodb.internal.connection.AsyncConnection;
import com.willfp.eco.libs.mongodb.internal.connection.Connection;
import com.willfp.eco.libs.mongodb.internal.connection.MessageSettings;
import com.willfp.eco.libs.mongodb.internal.connection.SplittablePayload;
import com.willfp.eco.libs.mongodb.internal.connection.SplittablePayloadBsonWriter;
import com.willfp.eco.libs.mongodb.internal.operation.ServerVersionHelper;
import com.willfp.eco.libs.mongodb.internal.validator.MappedFieldNameValidator;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.crypt.Crypt;
import com.willfp.eco.libs.reactor.core.publisher.Mono;
import java.util.HashMap;

class CryptConnection
implements AsyncConnection {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private static final int MAX_SPLITTABLE_DOCUMENT_SIZE = 0x200000;
    private final AsyncConnection wrapped;
    private final Crypt crypt;

    CryptConnection(AsyncConnection wrapped, Crypt crypt) {
        this.wrapped = wrapped;
        this.crypt = crypt;
    }

    @Override
    public int getCount() {
        return this.wrapped.getCount();
    }

    @Override
    public CryptConnection retain() {
        this.wrapped.retain();
        return this;
    }

    @Override
    public int release() {
        return this.wrapped.release();
    }

    @Override
    public ConnectionDescription getDescription() {
        return this.wrapped.getDescription();
    }

    @Override
    public <T> void commandAsync(String database, BsonDocument command2, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, BindingContext context, SingleResultCallback<T> callback) {
        this.commandAsync(database, command2, fieldNameValidator, readPreference, commandResultDecoder, context, true, null, null, callback);
    }

    @Override
    public <T> void commandAsync(String database, BsonDocument command2, FieldNameValidator commandFieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, BindingContext context, boolean responseExpected, @Nullable SplittablePayload payload, @Nullable FieldNameValidator payloadFieldNameValidator, SingleResultCallback<T> callback) {
        if (ServerVersionHelper.serverIsLessThanVersionFourDotTwo(this.wrapped.getDescription())) {
            callback.onResult(null, new MongoClientException("Auto-encryption requires a minimum MongoDB version of 4.2"));
            return;
        }
        try {
            BasicOutputBuffer bsonOutput = new BasicOutputBuffer();
            BsonBinaryWriter bsonBinaryWriter = new BsonBinaryWriter(new BsonWriterSettings(), new BsonBinaryWriterSettings(this.getDescription().getMaxDocumentSize()), bsonOutput, this.getFieldNameValidator(payload, commandFieldNameValidator, payloadFieldNameValidator));
            BsonWriter writer = payload == null ? bsonBinaryWriter : new SplittablePayloadBsonWriter(bsonBinaryWriter, (BsonOutput)bsonOutput, this.createSplittablePayloadMessageSettings(), payload, 0x200000);
            this.getEncoder(command2).encode(writer, command2, EncoderContext.builder().build());
            this.crypt.encrypt(database, new RawBsonDocument(bsonOutput.getInternalBuffer(), 0, bsonOutput.getSize())).flatMap(encryptedCommand -> Mono.create(sink -> this.wrapped.commandAsync(database, (BsonDocument)encryptedCommand, commandFieldNameValidator, readPreference, new RawBsonDocumentCodec(), context, responseExpected, null, null, MongoOperationPublisher.sinkToCallback(sink)))).flatMap(this.crypt::decrypt).map(decryptedResponse -> commandResultDecoder.decode(new BsonBinaryReader(decryptedResponse.getByteBuffer().asNIO()), DecoderContext.builder().build())).subscribe(decryptedResult -> callback.onResult(decryptedResult, null), e -> callback.onResult(null, (Throwable)e));
        }
        catch (Throwable t2) {
            callback.onResult(null, t2);
        }
    }

    private Codec<BsonDocument> getEncoder(BsonDocument command2) {
        return REGISTRY.get(command2.getClass());
    }

    private FieldNameValidator getFieldNameValidator(@Nullable SplittablePayload payload, FieldNameValidator commandFieldNameValidator, @Nullable FieldNameValidator payloadFieldNameValidator) {
        if (payload == null) {
            return commandFieldNameValidator;
        }
        HashMap<String, FieldNameValidator> rootMap = new HashMap<String, FieldNameValidator>();
        rootMap.put(payload.getPayloadName(), payloadFieldNameValidator);
        return new MappedFieldNameValidator(commandFieldNameValidator, rootMap);
    }

    private MessageSettings createSplittablePayloadMessageSettings() {
        return MessageSettings.builder().maxBatchCount(this.getDescription().getMaxBatchCount()).maxMessageSize(this.getDescription().getMaxMessageSize()).maxDocumentSize(this.getDescription().getMaxDocumentSize()).build();
    }

    @Override
    public void markAsPinned(Connection.PinningMode pinningMode) {
        this.wrapped.markAsPinned(pinningMode);
    }
}

