/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal.crypt;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.mongodb.MongoNamespace;
import com.willfp.eco.libs.mongodb.ReadConcern;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.reactivestreams.client.MongoClient;
import com.willfp.eco.libs.reactor.core.publisher.Flux;
import com.willfp.eco.libs.reactor.core.publisher.Mono;
import java.util.List;

class KeyRetriever {
    private final MongoClient client;
    private final MongoNamespace namespace;

    KeyRetriever(MongoClient client, MongoNamespace namespace) {
        this.client = Assertions.notNull("client", client);
        this.namespace = Assertions.notNull("namespace", namespace);
    }

    public Mono<List<BsonDocument>> find(BsonDocument keyFilter) {
        return Flux.from(this.client.getDatabase(this.namespace.getDatabaseName()).getCollection(this.namespace.getCollectionName(), BsonDocument.class).withReadConcern(ReadConcern.MAJORITY).find(keyFilter)).collectList();
    }
}

