/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal.gridfs;

import com.willfp.eco.libs.bson.Document;
import com.willfp.eco.libs.bson.types.Binary;
import com.willfp.eco.libs.mongodb.MongoGridFSException;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.client.gridfs.model.GridFSFile;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ClientSession;
import com.willfp.eco.libs.mongodb.reactivestreams.client.FindPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.MongoCollection;
import com.willfp.eco.libs.mongodb.reactivestreams.client.gridfs.GridFSDownloadPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.gridfs.ResizingByteBufferFlux;
import com.willfp.eco.libs.reactivestreams.Publisher;
import com.willfp.eco.libs.reactivestreams.Subscriber;
import com.willfp.eco.libs.reactor.core.publisher.Flux;
import com.willfp.eco.libs.reactor.core.publisher.Mono;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public class GridFSDownloadPublisherImpl
implements GridFSDownloadPublisher {
    private final ClientSession clientSession;
    private final Mono<GridFSFile> gridFSFileMono;
    private final MongoCollection<Document> chunksCollection;
    private Integer bufferSizeBytes;
    private volatile GridFSFile fileInfo;

    public GridFSDownloadPublisherImpl(@Nullable ClientSession clientSession, Mono<GridFSFile> gridFSFileMono, MongoCollection<Document> chunksCollection) {
        this.clientSession = clientSession;
        this.gridFSFileMono = Assertions.notNull("gridFSFileMono", gridFSFileMono).doOnSuccess(s2 -> {
            if (s2 == null) {
                throw new MongoGridFSException("File not found");
            }
        });
        this.chunksCollection = Assertions.notNull("chunksCollection", chunksCollection);
    }

    @Override
    public Publisher<GridFSFile> getGridFSFile() {
        if (this.fileInfo != null) {
            return Mono.fromCallable(() -> this.fileInfo);
        }
        return this.gridFSFileMono.doOnNext(i -> {
            this.fileInfo = i;
        });
    }

    @Override
    public GridFSDownloadPublisher bufferSizeBytes(int bufferSizeBytes) {
        this.bufferSizeBytes = bufferSizeBytes;
        return this;
    }

    @Override
    public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
        this.gridFSFileMono.flatMapMany(this::getChunkPublisher).subscribe(subscriber);
    }

    private Flux<ByteBuffer> getChunkPublisher(GridFSFile gridFSFile) {
        Document filter2 = new Document("files_id", gridFSFile.getId());
        FindPublisher<Document> chunkPublisher = this.clientSession != null ? this.chunksCollection.find(this.clientSession, filter2) : this.chunksCollection.find(filter2);
        AtomicInteger chunkCounter = new AtomicInteger(0);
        int numberOfChunks = (int)Math.ceil((double)gridFSFile.getLength() / (double)gridFSFile.getChunkSize());
        ResizingByteBufferFlux byteBufferFlux = Flux.from(chunkPublisher.sort(new Document("n", 1))).map(chunk -> {
            int expectedChunkIndex = chunkCounter.getAndAdd(1);
            if (chunk == null || chunk.getInteger("n") != expectedChunkIndex) {
                throw new MongoGridFSException(String.format("Could not find file chunk for files_id: %s at chunk index %s.", gridFSFile.getId(), expectedChunkIndex));
            }
            if (!(chunk.get("data") instanceof Binary)) {
                throw new MongoGridFSException("Unexpected data format for the chunk");
            }
            byte[] data2 = ((Binary)((Object)chunk.get((Object)"data", Binary.class))).getData();
            long expectedDataLength = 0L;
            if (numberOfChunks > 0) {
                long l = expectedDataLength = expectedChunkIndex + 1 == numberOfChunks ? gridFSFile.getLength() - (long)expectedChunkIndex * (long)gridFSFile.getChunkSize() : (long)gridFSFile.getChunkSize();
            }
            if ((long)data2.length != expectedDataLength) {
                throw new MongoGridFSException(String.format("Chunk size data length is not the expected size. The size was %s for file_id: %s chunk index %s it should be %s bytes.", data2.length, gridFSFile.getId(), expectedChunkIndex, expectedDataLength));
            }
            return ByteBuffer.wrap(data2);
        }).doOnComplete(() -> {
            if (chunkCounter.get() < numberOfChunks) {
                throw new MongoGridFSException(String.format("Could not find file chunk for files_id: %s at chunk index %s.", gridFSFile.getId(), chunkCounter.get()));
            }
        });
        return this.bufferSizeBytes == null ? byteBufferFlux : new ResizingByteBufferFlux(byteBufferFlux, this.bufferSizeBytes);
    }
}

