/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal.gridfs;

import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.lang.NonNull;
import com.willfp.eco.libs.reactivestreams.Publisher;
import com.willfp.eco.libs.reactivestreams.Subscriber;
import com.willfp.eco.libs.reactivestreams.Subscription;
import com.willfp.eco.libs.reactor.core.CoreSubscriber;
import com.willfp.eco.libs.reactor.core.publisher.BaseSubscriber;
import com.willfp.eco.libs.reactor.core.publisher.Flux;
import com.willfp.eco.libs.reactor.core.publisher.FluxSink;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;

class ResizingByteBufferFlux
extends Flux<ByteBuffer> {
    private final Publisher<ByteBuffer> source;
    private final int outputByteBufferSize;

    ResizingByteBufferFlux(Publisher<ByteBuffer> source, int outputByteBufferSize) {
        Assertions.notNull("source must not be null", source);
        Assertions.isTrue("'outputByteBufferSize' must be a positive number", outputByteBufferSize >= 0);
        this.source = source;
        this.outputByteBufferSize = outputByteBufferSize;
    }

    @Override
    public void subscribe(CoreSubscriber<? super ByteBuffer> actual) {
        Flux.push(sink -> {
            BaseSubscriber<ByteBuffer> subscriber = new BaseSubscriber<ByteBuffer>(){
                private volatile ByteBuffer remainder;
                private final AtomicLong requested = new AtomicLong();
                private volatile boolean startedProcessing = false;
                private volatile boolean finished = false;

                @Override
                protected void hookOnSubscribe(Subscription subscription) {
                    sink.onCancel(() -> this.upstream().cancel());
                    sink.onRequest(l -> {
                        1 var3_2 = this;
                        synchronized (var3_2) {
                            this.requested.addAndGet(l);
                            if (!this.startedProcessing) {
                                this.startedProcessing = true;
                                this.upstream().request(1L);
                            }
                        }
                    });
                }

                @Override
                protected void hookOnNext(@NonNull ByteBuffer value) {
                    if (this.remainder == null || this.remainder.remaining() == 0) {
                        this.remainder = value;
                    } else {
                        byte[] byteArray = new byte[this.remainder.remaining() + value.remaining()];
                        ByteBuffer newBuffer = ByteBuffer.wrap(byteArray);
                        this.copyByteBuffer(this.remainder, newBuffer);
                        this.copyByteBuffer(value, newBuffer);
                        ((Buffer)newBuffer).flip();
                        this.remainder = newBuffer;
                    }
                    while (this.remainder != null && this.remainder.remaining() >= ResizingByteBufferFlux.this.outputByteBufferSize) {
                        int newLimit = this.remainder.position() + ResizingByteBufferFlux.this.outputByteBufferSize;
                        ByteBuffer next = this.remainder.duplicate();
                        ((Buffer)next).limit(newLimit);
                        this.requested.decrementAndGet();
                        sink.next(next);
                        ((Buffer)this.remainder).position(newLimit);
                    }
                    if (this.requested.get() > 0L) {
                        this.upstream().request(1L);
                    }
                }

                @Override
                protected void hookOnComplete() {
                    if (!this.finished) {
                        this.finished = true;
                        if (this.remainder != null && this.remainder.remaining() > 0) {
                            sink.next(this.remainder);
                        }
                        sink.complete();
                    }
                }

                @Override
                protected void hookOnError(@NonNull Throwable throwable) {
                    sink.error(throwable);
                }

                private void copyByteBuffer(ByteBuffer original, ByteBuffer destination) {
                    if (original.hasArray() && destination.hasArray()) {
                        System.arraycopy(original.array(), original.position(), destination.array(), destination.position(), original.remaining());
                        ((Buffer)destination).position(destination.position() + original.remaining());
                    } else {
                        destination.put(original);
                    }
                }
            };
            this.source.subscribe((Subscriber<ByteBuffer>)subscriber);
        }, FluxSink.OverflowStrategy.BUFFER).subscribe(actual);
    }
}

