/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal.vault;

import com.willfp.eco.libs.bson.BsonArray;
import com.willfp.eco.libs.bson.BsonBinary;
import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonNull;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import com.willfp.eco.libs.bson.conversions.Bson;
import com.willfp.eco.libs.bson.internal.BsonUtil;
import com.willfp.eco.libs.mongodb.ClientEncryptionSettings;
import com.willfp.eco.libs.mongodb.MongoConfigurationException;
import com.willfp.eco.libs.mongodb.MongoNamespace;
import com.willfp.eco.libs.mongodb.MongoUpdatedEncryptedFieldsException;
import com.willfp.eco.libs.mongodb.ReadConcern;
import com.willfp.eco.libs.mongodb.WriteConcern;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.client.model.CreateCollectionOptions;
import com.willfp.eco.libs.mongodb.client.model.CreateEncryptedCollectionParams;
import com.willfp.eco.libs.mongodb.client.model.Filters;
import com.willfp.eco.libs.mongodb.client.model.UpdateOneModel;
import com.willfp.eco.libs.mongodb.client.model.Updates;
import com.willfp.eco.libs.mongodb.client.model.vault.DataKeyOptions;
import com.willfp.eco.libs.mongodb.client.model.vault.EncryptOptions;
import com.willfp.eco.libs.mongodb.client.model.vault.RewrapManyDataKeyOptions;
import com.willfp.eco.libs.mongodb.client.model.vault.RewrapManyDataKeyResult;
import com.willfp.eco.libs.mongodb.client.result.DeleteResult;
import com.willfp.eco.libs.mongodb.internal.capi.MongoCryptHelper;
import com.willfp.eco.libs.mongodb.reactivestreams.client.FindPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.MongoClient;
import com.willfp.eco.libs.mongodb.reactivestreams.client.MongoClients;
import com.willfp.eco.libs.mongodb.reactivestreams.client.MongoCollection;
import com.willfp.eco.libs.mongodb.reactivestreams.client.MongoDatabase;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.crypt.Crypt;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.crypt.Crypts;
import com.willfp.eco.libs.mongodb.reactivestreams.client.vault.ClientEncryption;
import com.willfp.eco.libs.reactivestreams.Publisher;
import com.willfp.eco.libs.reactor.core.publisher.Flux;
import com.willfp.eco.libs.reactor.core.publisher.Mono;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class ClientEncryptionImpl
implements ClientEncryption {
    private final Crypt crypt;
    private final ClientEncryptionSettings options;
    private final MongoClient keyVaultClient;
    private final MongoCollection<BsonDocument> collection;

    public ClientEncryptionImpl(ClientEncryptionSettings options2) {
        this(MongoClients.create(options2.getKeyVaultMongoClientSettings()), options2);
    }

    public ClientEncryptionImpl(MongoClient keyVaultClient, ClientEncryptionSettings options2) {
        this.keyVaultClient = keyVaultClient;
        this.crypt = Crypts.create(keyVaultClient, options2);
        this.options = options2;
        MongoNamespace namespace = new MongoNamespace(options2.getKeyVaultNamespace());
        this.collection = keyVaultClient.getDatabase(namespace.getDatabaseName()).getCollection(namespace.getCollectionName(), BsonDocument.class).withWriteConcern(WriteConcern.MAJORITY).withReadConcern(ReadConcern.MAJORITY);
    }

    @Override
    public Publisher<BsonBinary> createDataKey(String kmsProvider) {
        return this.createDataKey(kmsProvider, new DataKeyOptions());
    }

    @Override
    public Publisher<BsonBinary> createDataKey(String kmsProvider, DataKeyOptions dataKeyOptions) {
        return this.crypt.createDataKey(kmsProvider, dataKeyOptions).flatMap(dataKeyDocument -> {
            MongoNamespace namespace = new MongoNamespace(this.options.getKeyVaultNamespace());
            return Mono.from(this.keyVaultClient.getDatabase(namespace.getDatabaseName()).getCollection(namespace.getCollectionName(), BsonDocument.class).withWriteConcern(WriteConcern.MAJORITY).insertOne((BsonDocument)dataKeyDocument)).map(i -> dataKeyDocument.getBinary("_id"));
        });
    }

    @Override
    public Publisher<BsonBinary> encrypt(BsonValue value, EncryptOptions options2) {
        return this.crypt.encryptExplicitly(value, options2);
    }

    @Override
    public Publisher<BsonDocument> encryptExpression(Bson expression, EncryptOptions options2) {
        return this.crypt.encryptExpression(expression.toBsonDocument(BsonDocument.class, this.collection.getCodecRegistry()), options2);
    }

    @Override
    public Publisher<BsonValue> decrypt(BsonBinary value) {
        return this.crypt.decryptExplicitly(value);
    }

    @Override
    public Publisher<DeleteResult> deleteKey(BsonBinary id2) {
        return this.collection.deleteOne(Filters.eq("_id", id2));
    }

    @Override
    public Publisher<BsonDocument> getKey(BsonBinary id2) {
        return this.collection.find(Filters.eq("_id", id2)).first();
    }

    @Override
    public FindPublisher<BsonDocument> getKeys() {
        return this.collection.find();
    }

    @Override
    public Publisher<BsonDocument> addKeyAltName(BsonBinary id2, String keyAltName) {
        return this.collection.findOneAndUpdate(Filters.eq("_id", id2), Updates.addToSet("keyAltNames", keyAltName));
    }

    @Override
    public Publisher<BsonDocument> removeKeyAltName(BsonBinary id2, String keyAltName) {
        BsonDocument updateDocument = new BsonDocument().append("$set", new BsonDocument().append("keyAltNames", new BsonDocument().append("$cond", new BsonArray(Arrays.asList(new BsonDocument().append("$eq", new BsonArray(Arrays.asList(new BsonString("$keyAltNames"), new BsonArray(Collections.singletonList(new BsonString(keyAltName)))))), new BsonString("$$REMOVE"), new BsonDocument().append("$filter", new BsonDocument().append("input", new BsonString("$keyAltNames")).append("cond", new BsonDocument().append("$ne", new BsonArray(Arrays.asList(new BsonString("$$this"), new BsonString(keyAltName)))))))))));
        return this.collection.findOneAndUpdate(Filters.eq("_id", id2), Collections.singletonList(updateDocument));
    }

    @Override
    public Publisher<BsonDocument> getKeyByAltName(String keyAltName) {
        return this.collection.find(Filters.eq("keyAltNames", keyAltName)).first();
    }

    @Override
    public Publisher<RewrapManyDataKeyResult> rewrapManyDataKey(Bson filter2) {
        return this.rewrapManyDataKey(filter2, new RewrapManyDataKeyOptions());
    }

    @Override
    public Publisher<RewrapManyDataKeyResult> rewrapManyDataKey(Bson filter2, RewrapManyDataKeyOptions options2) {
        return Mono.fromRunnable(() -> MongoCryptHelper.validateRewrapManyDataKeyOptions(options2)).then(this.crypt.rewrapManyDataKey(filter2.toBsonDocument(BsonDocument.class, this.collection.getCodecRegistry()), options2).flatMap(results -> {
            if (results.isEmpty()) {
                return Mono.fromCallable(RewrapManyDataKeyResult::new);
            }
            List updateModels = results.getArray("v", new BsonArray()).stream().map(v -> {
                BsonDocument updateDocument = v.asDocument();
                return new UpdateOneModel(Filters.eq(updateDocument.get("_id")), Updates.combine(Updates.set("masterKey", updateDocument.get("masterKey")), Updates.set("keyMaterial", updateDocument.get("keyMaterial")), Updates.currentDate("updateDate")));
            }).collect(Collectors.toList());
            return Mono.from(this.collection.bulkWrite(updateModels)).map(RewrapManyDataKeyResult::new);
        }));
    }

    @Override
    public Publisher<BsonDocument> createEncryptedCollection(MongoDatabase database, String collectionName, CreateCollectionOptions createCollectionOptions, CreateEncryptedCollectionParams createEncryptedCollectionParams) {
        Assertions.notNull("collectionName", collectionName);
        Assertions.notNull("createCollectionOptions", createCollectionOptions);
        Assertions.notNull("createEncryptedCollectionParams", createEncryptedCollectionParams);
        MongoNamespace namespace = new MongoNamespace(database.getName(), collectionName);
        Bson rawEncryptedFields = createCollectionOptions.getEncryptedFields();
        if (rawEncryptedFields == null) {
            throw new MongoConfigurationException(String.format("`encryptedFields` is not configured for the collection %s.", namespace));
        }
        CodecRegistry codecRegistry = this.options.getKeyVaultMongoClientSettings().getCodecRegistry();
        BsonDocument encryptedFields = rawEncryptedFields.toBsonDocument(BsonDocument.class, codecRegistry);
        BsonValue fields2 = encryptedFields.get("fields");
        if (fields2 != null && fields2.isArray()) {
            String kmsProvider = createEncryptedCollectionParams.getKmsProvider();
            DataKeyOptions dataKeyOptions = new DataKeyOptions();
            BsonDocument masterKey = createEncryptedCollectionParams.getMasterKey();
            if (masterKey != null) {
                dataKeyOptions.masterKey(masterKey);
            }
            String keyIdBsonKey = "keyId";
            return Mono.defer(() -> {
                BsonDocument maybeUpdatedEncryptedFields = BsonUtil.mutableDeepCopy(encryptedFields);
                AtomicBoolean dataKeyMightBeCreated = new AtomicBoolean();
                Iterable publishersOfUpdatedFields = () -> maybeUpdatedEncryptedFields.get("fields").asArray().stream().filter(BsonValue::isDocument).map(BsonValue::asDocument).filter(field -> field.containsKey(keyIdBsonKey)).filter(field -> Objects.equals(field.get(keyIdBsonKey), BsonNull.VALUE)).map(field -> Mono.fromDirect(this.createDataKey(kmsProvider, dataKeyOptions)).doOnSubscribe(subscription -> dataKeyMightBeCreated.set(true)).doOnNext(dataKeyId -> field.put(keyIdBsonKey, (BsonValue)dataKeyId)).map(dataKeyId -> field)).iterator();
                Flux publisherOfUpdatedFields = Flux.concat(publishersOfUpdatedFields);
                return publisherOfUpdatedFields.thenEmpty(Mono.defer(() -> Mono.fromDirect(database.createCollection(collectionName, new CreateCollectionOptions(createCollectionOptions).encryptedFields(maybeUpdatedEncryptedFields))))).onErrorMap(e -> dataKeyMightBeCreated.get(), e -> new MongoUpdatedEncryptedFieldsException(maybeUpdatedEncryptedFields, String.format("Failed to create %s.", namespace), (Throwable)e)).thenReturn(maybeUpdatedEncryptedFields);
            });
        }
        return Mono.fromDirect(database.createCollection(collectionName, createCollectionOptions)).thenReturn(encryptedFields);
    }

    @Override
    public void close() {
        this.keyVaultClient.close();
        this.crypt.close();
    }
}

