/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.objenesis.strategy;

import com.willfp.eco.libs.objenesis.ObjenesisException;
import com.willfp.eco.libs.objenesis.instantiator.ObjectInstantiator;
import com.willfp.eco.libs.objenesis.instantiator.android.AndroidSerializationInstantiator;
import com.willfp.eco.libs.objenesis.instantiator.basic.ObjectInputStreamInstantiator;
import com.willfp.eco.libs.objenesis.instantiator.basic.ObjectStreamClassInstantiator;
import com.willfp.eco.libs.objenesis.instantiator.gcj.GCJSerializationInstantiator;
import com.willfp.eco.libs.objenesis.instantiator.perc.PercSerializationInstantiator;
import com.willfp.eco.libs.objenesis.instantiator.sun.SunReflectionFactorySerializationInstantiator;
import com.willfp.eco.libs.objenesis.strategy.BaseInstantiatorStrategy;
import com.willfp.eco.libs.objenesis.strategy.PlatformDescription;
import java.io.NotSerializableException;
import java.io.Serializable;

public class SerializingInstantiatorStrategy
extends BaseInstantiatorStrategy {
    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type2) {
        if (!Serializable.class.isAssignableFrom(type2)) {
            throw new ObjenesisException(new NotSerializableException(type2 + " not serializable"));
        }
        if (PlatformDescription.JVM_NAME.startsWith("Java HotSpot") || PlatformDescription.isThisJVM("OpenJDK")) {
            if (PlatformDescription.isGoogleAppEngine() && PlatformDescription.SPECIFICATION_VERSION.equals("1.7")) {
                return new ObjectInputStreamInstantiator<T>(type2);
            }
            return new SunReflectionFactorySerializationInstantiator<T>(type2);
        }
        if (PlatformDescription.JVM_NAME.startsWith("Dalvik")) {
            if (PlatformDescription.isAndroidOpenJDK()) {
                return new ObjectStreamClassInstantiator<T>(type2);
            }
            return new AndroidSerializationInstantiator<T>(type2);
        }
        if (PlatformDescription.JVM_NAME.startsWith("GNU libgcj")) {
            return new GCJSerializationInstantiator<T>(type2);
        }
        if (PlatformDescription.JVM_NAME.startsWith("PERC")) {
            return new PercSerializationInstantiator<T>(type2);
        }
        return new SunReflectionFactorySerializationInstantiator<T>(type2);
    }
}

