/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.objenesis.strategy;

import com.willfp.eco.libs.objenesis.instantiator.ObjectInstantiator;
import com.willfp.eco.libs.objenesis.instantiator.android.Android10Instantiator;
import com.willfp.eco.libs.objenesis.instantiator.android.Android17Instantiator;
import com.willfp.eco.libs.objenesis.instantiator.android.Android18Instantiator;
import com.willfp.eco.libs.objenesis.instantiator.basic.AccessibleInstantiator;
import com.willfp.eco.libs.objenesis.instantiator.basic.ObjectInputStreamInstantiator;
import com.willfp.eco.libs.objenesis.instantiator.gcj.GCJInstantiator;
import com.willfp.eco.libs.objenesis.instantiator.perc.PercInstantiator;
import com.willfp.eco.libs.objenesis.instantiator.sun.SunReflectionFactoryInstantiator;
import com.willfp.eco.libs.objenesis.instantiator.sun.UnsafeFactoryInstantiator;
import com.willfp.eco.libs.objenesis.strategy.BaseInstantiatorStrategy;
import com.willfp.eco.libs.objenesis.strategy.PlatformDescription;
import java.io.Serializable;

public class StdInstantiatorStrategy
extends BaseInstantiatorStrategy {
    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type2) {
        if (PlatformDescription.isThisJVM("Java HotSpot") || PlatformDescription.isThisJVM("OpenJDK")) {
            if (PlatformDescription.isGoogleAppEngine() && PlatformDescription.SPECIFICATION_VERSION.equals("1.7")) {
                if (Serializable.class.isAssignableFrom(type2)) {
                    return new ObjectInputStreamInstantiator<T>(type2);
                }
                return new AccessibleInstantiator<T>(type2);
            }
            return new SunReflectionFactoryInstantiator<T>(type2);
        }
        if (PlatformDescription.isThisJVM("Dalvik")) {
            if (PlatformDescription.isAndroidOpenJDK()) {
                return new UnsafeFactoryInstantiator<T>(type2);
            }
            if (PlatformDescription.ANDROID_VERSION <= 10) {
                return new Android10Instantiator<T>(type2);
            }
            if (PlatformDescription.ANDROID_VERSION <= 17) {
                return new Android17Instantiator<T>(type2);
            }
            return new Android18Instantiator<T>(type2);
        }
        if (PlatformDescription.isThisJVM("GNU libgcj")) {
            return new GCJInstantiator<T>(type2);
        }
        if (PlatformDescription.isThisJVM("PERC")) {
            return new PercInstantiator<T>(type2);
        }
        return new UnsafeFactoryInstantiator<T>(type2);
    }
}

