/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.reactor.adapter;

import com.willfp.eco.libs.reactivestreams.Publisher;
import com.willfp.eco.libs.reactivestreams.Subscriber;
import com.willfp.eco.libs.reactivestreams.Subscription;
import com.willfp.eco.libs.reactor.core.CoreSubscriber;
import com.willfp.eco.libs.reactor.core.Scannable;
import com.willfp.eco.libs.reactor.core.publisher.Flux;
import java.util.concurrent.Flow;

public abstract class JdkFlowAdapter {
    public static <T> Flow.Publisher<T> publisherToFlowPublisher(Publisher<T> publisher) {
        return new PublisherAsFlowPublisher(publisher);
    }

    public static <T> Flux<T> flowPublisherToFlux(Flow.Publisher<T> publisher) {
        return new FlowPublisherAsFlux(publisher);
    }

    JdkFlowAdapter() {
    }

    private static class SubscriberToRS<T>
    implements Flow.Subscriber<T>,
    Subscription {
        private final Subscriber<? super T> s;
        Flow.Subscription subscription;

        public SubscriberToRS(Subscriber<? super T> s2) {
            this.s = s2;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            this.s.onSubscribe(this);
        }

        @Override
        public void onNext(T o) {
            this.s.onNext(o);
        }

        @Override
        public void onError(Throwable throwable) {
            this.s.onError(throwable);
        }

        @Override
        public void onComplete() {
            this.s.onComplete();
        }

        @Override
        public void request(long n) {
            this.subscription.request(n);
        }

        @Override
        public void cancel() {
            this.subscription.cancel();
        }
    }

    private static class FlowSubscriber<T>
    implements CoreSubscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super T> subscriber;
        Subscription subscription;

        public FlowSubscriber(Flow.Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            this.subscription = s2;
            this.subscriber.onSubscribe(this);
        }

        @Override
        public void onNext(T o) {
            this.subscriber.onNext(o);
        }

        @Override
        public void onError(Throwable t2) {
            this.subscriber.onError(t2);
        }

        @Override
        public void onComplete() {
            this.subscriber.onComplete();
        }

        @Override
        public void request(long n) {
            this.subscription.request(n);
        }

        @Override
        public void cancel() {
            this.subscription.cancel();
        }
    }

    private static class PublisherAsFlowPublisher<T>
    implements Flow.Publisher<T> {
        private final Publisher<T> pub;

        private PublisherAsFlowPublisher(Publisher<T> pub) {
            this.pub = pub;
        }

        @Override
        public void subscribe(Flow.Subscriber<? super T> subscriber) {
            this.pub.subscribe(new FlowSubscriber<T>(subscriber));
        }
    }

    private static class FlowPublisherAsFlux<T>
    extends Flux<T>
    implements Scannable {
        private final Flow.Publisher<T> pub;

        private FlowPublisherAsFlux(Flow.Publisher<T> pub) {
            this.pub = pub;
        }

        @Override
        public void subscribe(CoreSubscriber<? super T> actual) {
            this.pub.subscribe(new SubscriberToRS<T>(actual));
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            return null;
        }
    }
}

