/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.reactor.core.publisher;

import com.willfp.eco.libs.reactivestreams.Publisher;
import com.willfp.eco.libs.reactivestreams.Subscriber;
import com.willfp.eco.libs.reactor.core.CorePublisher;
import com.willfp.eco.libs.reactor.core.CoreSubscriber;
import com.willfp.eco.libs.reactor.core.publisher.FluxContextWrite;
import com.willfp.eco.libs.reactor.core.publisher.Operators;
import com.willfp.eco.libs.reactor.util.context.Context;
import java.util.function.Function;

class ContextTrackingFunctionWrapper<T, V>
implements Function<Publisher<T>, CorePublisher<V>> {
    static final String CONTEXT_MARKER_PREFIX = "com.willfp.eco.libs.reactor.core.context.marker.";
    final Function<? super Publisher<T>, ? extends Publisher<V>> transformer;
    final String marker;

    ContextTrackingFunctionWrapper(Function<? super Publisher<T>, ? extends Publisher<V>> transformer) {
        this(transformer, transformer.toString());
    }

    ContextTrackingFunctionWrapper(Function<? super Publisher<T>, ? extends Publisher<V>> transformer, String marker) {
        this.transformer = transformer;
        this.marker = marker;
    }

    @Override
    public CorePublisher<V> apply(Publisher<T> source) {
        final String key = CONTEXT_MARKER_PREFIX + System.identityHashCode(source);
        source = Operators.liftPublisher((p, actual) -> {
            Context ctx = actual.currentContext();
            if (!ctx.hasKey(key)) {
                throw new IllegalStateException("Context loss after applying " + this.marker);
            }
            Context newContext = ctx.delete(key);
            return new FluxContextWrite.ContextWriteSubscriber(actual, newContext);
        }).apply(source);
        final Publisher<V> result2 = this.transformer.apply(source);
        return new CorePublisher<V>(){

            @Override
            public void subscribe(CoreSubscriber<? super V> actual) {
                Context ctx = actual.currentContext().put(key, true);
                FluxContextWrite.ContextWriteSubscriber subscriber = new FluxContextWrite.ContextWriteSubscriber(actual, ctx);
                if (result2 instanceof CorePublisher) {
                    ((CorePublisher)result2).subscribe(subscriber);
                } else {
                    result2.subscribe(subscriber);
                }
            }

            @Override
            public void subscribe(Subscriber<? super V> subscriber) {
                this.subscribe(Operators.toCoreSubscriber(subscriber));
            }
        };
    }
}

