/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.reactor.core.publisher;

import com.willfp.eco.libs.reactor.core.CoreSubscriber;
import com.willfp.eco.libs.reactor.core.Fuseable;
import com.willfp.eco.libs.reactor.core.Scannable;
import com.willfp.eco.libs.reactor.core.publisher.Flux;
import com.willfp.eco.libs.reactor.core.publisher.FluxNameFuseable;
import com.willfp.eco.libs.reactor.core.publisher.InternalFluxOperator;
import com.willfp.eco.libs.reactor.util.annotation.Nullable;
import com.willfp.eco.libs.reactor.util.function.Tuple2;
import com.willfp.eco.libs.reactor.util.function.Tuples;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

final class FluxName<T>
extends InternalFluxOperator<T, T> {
    final String name;
    final List<Tuple2<String, String>> tagsWithDuplicates;

    static <T> Flux<T> createOrAppend(Flux<T> source, String name) {
        Objects.requireNonNull(name, "name");
        if (source instanceof FluxName) {
            FluxName s2 = (FluxName)source;
            return new FluxName<T>(s2.source, name, s2.tagsWithDuplicates);
        }
        if (source instanceof FluxNameFuseable) {
            FluxNameFuseable s3 = (FluxNameFuseable)source;
            return new FluxNameFuseable(s3.source, name, s3.tagsWithDuplicates);
        }
        if (source instanceof Fuseable) {
            return new FluxNameFuseable<T>(source, name, null);
        }
        return new FluxName<T>(source, name, null);
    }

    static <T> Flux<T> createOrAppend(Flux<T> source, String tagName, String tagValue) {
        Objects.requireNonNull(tagName, "tagName");
        Objects.requireNonNull(tagValue, "tagValue");
        Tuple2<String, String> newTag = Tuples.of(tagName, tagValue);
        if (source instanceof FluxName) {
            List<Tuple2<String, String>> tags;
            FluxName s2 = (FluxName)source;
            if (s2.tagsWithDuplicates != null) {
                tags = new LinkedList<Tuple2<String, String>>(s2.tagsWithDuplicates);
                tags.add(newTag);
            } else {
                tags = Collections.singletonList(newTag);
            }
            return new FluxName<T>(s2.source, s2.name, tags);
        }
        if (source instanceof FluxNameFuseable) {
            List<Tuple2<String, String>> tags;
            FluxNameFuseable s3 = (FluxNameFuseable)source;
            if (s3.tagsWithDuplicates != null) {
                tags = new LinkedList<Tuple2<String, String>>(s3.tagsWithDuplicates);
                tags.add(newTag);
            } else {
                tags = Collections.singletonList(newTag);
            }
            return new FluxNameFuseable(s3.source, s3.name, tags);
        }
        if (source instanceof Fuseable) {
            return new FluxNameFuseable<T>(source, null, Collections.singletonList(newTag));
        }
        return new FluxName<T>(source, null, Collections.singletonList(newTag));
    }

    FluxName(Flux<? extends T> source, @Nullable String name, @Nullable List<Tuple2<String, String>> tags) {
        super(source);
        this.name = name;
        this.tagsWithDuplicates = tags;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return actual;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.NAME) {
            return this.name;
        }
        if (key == Scannable.Attr.TAGS && this.tagsWithDuplicates != null) {
            return this.tagsWithDuplicates.stream();
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

