/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.reactor.core.publisher;

import com.willfp.eco.libs.reactor.core.CoreSubscriber;
import com.willfp.eco.libs.reactor.core.Exceptions;
import com.willfp.eco.libs.reactor.core.Scannable;
import com.willfp.eco.libs.reactor.core.publisher.Mono;
import com.willfp.eco.libs.reactor.core.publisher.Operators;
import com.willfp.eco.libs.reactor.core.publisher.SourceProducer;
import com.willfp.eco.libs.reactor.util.annotation.Nullable;
import java.time.Duration;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.Callable;

final class MonoSingleCallable<T>
extends Mono<T>
implements Callable<T>,
SourceProducer<T> {
    final Callable<? extends T> callable;
    @Nullable
    final T defaultValue;

    MonoSingleCallable(Callable<? extends T> source) {
        this.callable = Objects.requireNonNull(source, "source");
        this.defaultValue = null;
    }

    MonoSingleCallable(Callable<? extends T> source, T defaultValue) {
        this.callable = Objects.requireNonNull(source, "source");
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Operators.MonoInnerProducerBase<T> sds = new Operators.MonoInnerProducerBase<T>(actual);
        actual.onSubscribe(sds);
        if (sds.isCancelled()) {
            return;
        }
        try {
            T t2 = this.callable.call();
            if (t2 == null && this.defaultValue == null) {
                actual.onError(new NoSuchElementException("Source was empty"));
            } else if (t2 == null) {
                sds.complete(this.defaultValue);
            } else {
                sds.complete(t2);
            }
        }
        catch (Throwable e) {
            actual.onError(Operators.onOperatorError(e, actual.currentContext()));
        }
    }

    @Override
    public T block() {
        return this.block(Duration.ZERO);
    }

    @Override
    public T block(Duration m4) {
        T v;
        try {
            v = this.callable.call();
        }
        catch (Throwable e) {
            throw Exceptions.propagate(e);
        }
        if (v == null && this.defaultValue == null) {
            throw new NoSuchElementException("Source was empty");
        }
        if (v == null) {
            return this.defaultValue;
        }
        return v;
    }

    @Override
    public T call() throws Exception {
        T v = this.callable.call();
        if (v == null && this.defaultValue == null) {
            throw new NoSuchElementException("Source was empty");
        }
        if (v == null) {
            return this.defaultValue;
        }
        return v;
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }
}

