/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.reflections.scanners;

import com.willfp.eco.libs.reflections.Configuration;
import com.willfp.eco.libs.reflections.ReflectionsException;
import com.willfp.eco.libs.reflections.Store;
import com.willfp.eco.libs.reflections.adapters.MetadataAdapter;
import com.willfp.eco.libs.reflections.scanners.Scanner;
import com.willfp.eco.libs.reflections.util.Utils;
import com.willfp.eco.libs.reflections.vfs.Vfs;
import java.util.function.Predicate;

public abstract class AbstractScanner
implements Scanner {
    private Configuration configuration;
    private Predicate<String> resultFilter = s2 -> true;

    @Override
    public boolean acceptsInput(String file) {
        return this.getMetadataAdapter().acceptsInput(file);
    }

    @Override
    public Object scan(Vfs.File file, Object classObject, Store store) {
        if (classObject == null) {
            try {
                classObject = this.configuration.getMetadataAdapter().getOrCreateClassObject(file);
            }
            catch (Exception e) {
                throw new ReflectionsException("could not create class object from file " + file.getRelativePath(), e);
            }
        }
        this.scan(classObject, store);
        return classObject;
    }

    public abstract void scan(Object var1, Store var2);

    protected void put(Store store, String key, String value) {
        store.put(Utils.index(this.getClass()), key, value);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Predicate<String> getResultFilter() {
        return this.resultFilter;
    }

    public void setResultFilter(Predicate<String> resultFilter) {
        this.resultFilter = resultFilter;
    }

    @Override
    public Scanner filterResultsBy(Predicate<String> filter2) {
        this.setResultFilter(filter2);
        return this;
    }

    @Override
    public boolean acceptResult(String fqn) {
        return fqn != null && this.resultFilter.test(fqn);
    }

    protected MetadataAdapter getMetadataAdapter() {
        return this.configuration.getMetadataAdapter();
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

