/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.util;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public final class DurabilityUtils {
    public static void damageItem(@NotNull Player player, @NotNull ItemStack item, int damage) {
        if (item.getItemMeta() == null) {
            return;
        }
        if (item.getItemMeta().isUnbreakable()) {
            return;
        }
        if (!(item.getItemMeta() instanceof Damageable)) {
            return;
        }
        if (item.getType() == Material.CARVED_PUMPKIN || item.getType() == Material.PLAYER_HEAD) {
            return;
        }
        PlayerItemDamageEvent event3 = new PlayerItemDamageEvent(player, item, damage);
        Bukkit.getPluginManager().callEvent((Event)event3);
        if (!event3.isCancelled()) {
            int damage2 = event3.getDamage();
            Damageable meta = (Damageable)item.getItemMeta();
            meta.setDamage(meta.getDamage() + damage2);
            if (meta.getDamage() >= item.getType().getMaxDurability()) {
                meta.setDamage((int)item.getType().getMaxDurability());
                item.setItemMeta((ItemMeta)meta);
                PlayerItemBreakEvent event = new PlayerItemBreakEvent(player, item);
                Bukkit.getPluginManager().callEvent((Event)event);
                item.setType(Material.AIR);
                player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else {
                item.setItemMeta((ItemMeta)meta);
            }
        }
    }

    public static void damageItem(@NotNull ItemStack item, int damage) {
        if (item.getItemMeta() == null) {
            return;
        }
        if (item.getItemMeta().isUnbreakable()) {
            return;
        }
        if (!(item.getItemMeta() instanceof Damageable)) {
            return;
        }
        if (item.getType() == Material.CARVED_PUMPKIN || item.getType() == Material.PLAYER_HEAD) {
            return;
        }
        Damageable meta = (Damageable)item.getItemMeta();
        meta.setDamage(meta.getDamage() + damage);
        if (meta.getDamage() >= item.getType().getMaxDurability()) {
            meta.setDamage((int)item.getType().getMaxDurability());
            item.setItemMeta((ItemMeta)meta);
            item.setType(Material.AIR);
        } else {
            item.setItemMeta((ItemMeta)meta);
        }
    }

    public static void damageItemNoBreak(@NotNull ItemStack item, int damage, @NotNull Player player) {
        if (item.getItemMeta() == null) {
            return;
        }
        if (item.getItemMeta().isUnbreakable()) {
            return;
        }
        if (!(item.getItemMeta() instanceof Damageable)) {
            return;
        }
        PlayerItemDamageEvent event3 = new PlayerItemDamageEvent(player, item, damage);
        Bukkit.getPluginManager().callEvent((Event)event3);
        if (!event3.isCancelled()) {
            int damage2 = event3.getDamage();
            Damageable meta = (Damageable)item.getItemMeta();
            meta.setDamage(meta.getDamage() + damage2);
            if (meta.getDamage() >= item.getType().getMaxDurability()) {
                meta.setDamage(item.getType().getMaxDurability() - 1);
            }
            item.setItemMeta((ItemMeta)meta);
        }
    }

    public static void repairItem(@NotNull ItemStack item, int repair) {
        if (item.getItemMeta() == null) {
            return;
        }
        if (item.getItemMeta().isUnbreakable()) {
            return;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta instanceof Damageable) {
            Damageable meta = (Damageable)itemMeta;
            meta.setDamage(meta.getDamage() - repair);
            if (meta.getDamage() < 0) {
                meta.setDamage(0);
            }
            item.setItemMeta((ItemMeta)meta);
        }
    }

    private DurabilityUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

