/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.util;

import com.willfp.eco.core.Eco;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Objects;
import org.bukkit.NamespacedKey;

public final class NamespacedKeyUtils {
    @NotNull
    public static NamespacedKey createEcoKey(@NotNull String string) {
        return NamespacedKeyUtils.create("eco", string);
    }

    @NotNull
    public static NamespacedKey create(@NotNull String namespace, @NotNull String key) {
        return Eco.get().createNamespacedKey(namespace, key);
    }

    @NotNull
    public static NamespacedKey fromString(@NotNull String string) {
        return Objects.requireNonNull(NamespacedKeyUtils.fromStringOrNull(string));
    }

    @Nullable
    public static NamespacedKey fromStringOrNull(@NotNull String string) {
        int index = string.indexOf(":");
        if (index < 0) {
            return null;
        }
        return NamespacedKeyUtils.create(string.substring(0, index), string.substring(index + 1));
    }

    private NamespacedKeyUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

