/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.util;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.NamespacedKeyUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.NamespacedKey;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u001b\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u001b\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0015\u0010\t\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\n2\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"namespacedKeyOf", "Lorg/bukkit/NamespacedKey;", "Lcom/willfp/eco/libs/jetbrains/annotations/NotNull;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "key", "", "string", "namespace", "safeNamespacedKeyOf", "Lcom/willfp/eco/libs/jetbrains/annotations/Nullable;", "eco-api"})
@JvmName(name="NamespacedKeyUtilsExtensions")
public final class NamespacedKeyUtilsExtensions {
    @NotNull
    public static final NamespacedKey namespacedKeyOf(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        NamespacedKey namespacedKey = NamespacedKeyUtils.fromString(string);
        Intrinsics.checkNotNullExpressionValue(namespacedKey, "fromString(...)");
        return namespacedKey;
    }

    @Nullable
    public static final NamespacedKey safeNamespacedKeyOf(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        return NamespacedKeyUtils.fromStringOrNull(string);
    }

    @NotNull
    public static final NamespacedKey namespacedKeyOf(@NotNull String namespace, @NotNull String key) {
        Intrinsics.checkNotNullParameter(namespace, "namespace");
        Intrinsics.checkNotNullParameter(key, "key");
        NamespacedKey namespacedKey = NamespacedKeyUtils.create(namespace, key);
        Intrinsics.checkNotNullExpressionValue(namespacedKey, "create(...)");
        return namespacedKey;
    }

    @NotNull
    public static final NamespacedKey namespacedKeyOf(@NotNull EcoPlugin plugin, @NotNull String key) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(key, "key");
        NamespacedKey namespacedKey = plugin.createNamespacedKey(key);
        Intrinsics.checkNotNullExpressionValue(namespacedKey, "createNamespacedKey(...)");
        return namespacedKey;
    }
}

