/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.util;

import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.NumberUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\"\u0010\u0006\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\b\u001a\u0016\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\r\u001a\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\u0003*\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u000f*\u00020\u0003\u001a\n\u0010\u0013\u001a\u00020\u0003*\u00020\u0011\u00a8\u0006\u0014"}, d2={"evaluateExpression", "", "expression", "", "context", "Lcom/willfp/eco/core/placeholder/context/PlaceholderContext;", "evaluateExpressionOrNull", "Lcom/willfp/eco/libs/jetbrains/annotations/Nullable;", "(Ljava/lang/String;Lcom/willfp/eco/core/placeholder/context/PlaceholderContext;)Ljava/lang/Double;", "randDouble", "min", "max", "randFloat", "", "randInt", "", "formatWithCommas", "", "parseNumeral", "toNumeral", "eco-api"})
@JvmName(name="NumberUtilsExtensions")
public final class NumberUtilsExtensions {
    @NotNull
    public static final String toNumeral(@NotNull Number $this$toNumeral) {
        Intrinsics.checkNotNullParameter($this$toNumeral, "<this>");
        String string = NumberUtils.toNumeral($this$toNumeral.intValue());
        Intrinsics.checkNotNullExpressionValue(string, "toNumeral(...)");
        return string;
    }

    @NotNull
    public static final String formatWithCommas(@NotNull Number $this$formatWithCommas) {
        Intrinsics.checkNotNullParameter($this$formatWithCommas, "<this>");
        String string = NumberUtils.formatWithCommas($this$formatWithCommas.doubleValue());
        Intrinsics.checkNotNullExpressionValue(string, "formatWithCommas(...)");
        return string;
    }

    public static final int parseNumeral(@NotNull String $this$parseNumeral) {
        Intrinsics.checkNotNullParameter($this$parseNumeral, "<this>");
        return NumberUtils.fromNumeral($this$parseNumeral);
    }

    public static final int randInt(int min2, int max) {
        return NumberUtils.randInt(min2, max);
    }

    public static final double randDouble(double min2, double max) {
        return NumberUtils.randFloat(min2, max);
    }

    public static final float randFloat(float min2, float max) {
        return (float)NumberUtils.randFloat(min2, max);
    }

    public static final double evaluateExpression(@NotNull String expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        return NumberUtils.evaluateExpression(expression);
    }

    public static final double evaluateExpression(@NotNull String expression, @NotNull PlaceholderContext context) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        return NumberUtils.evaluateExpression(expression, context);
    }

    @Nullable
    public static final Double evaluateExpressionOrNull(@NotNull String expression, @NotNull PlaceholderContext context) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        return NumberUtils.evaluateExpressionOrNull(expression, context);
    }
}

