/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.willfp.eco.core.Eco;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public final class PatternUtils {
    private static final Cache<String, Pattern> LITERAL_PATTERN_CACHE = Caffeine.newBuilder().expireAfterAccess(Eco.get().getEcoPlugin().getConfigYml().getInt("literal-cache-ttl"), TimeUnit.MINUTES).build();

    @NotNull
    public static Pattern compileLiteral(@NotNull String pattern) {
        return LITERAL_PATTERN_CACHE.get(pattern, it -> Pattern.compile(it, 16));
    }

    private PatternUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

