/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.util;

import com.willfp.eco.core.Eco;
import com.willfp.eco.core.Prerequisite;
import com.willfp.eco.core.data.PlayerProfile;
import com.willfp.eco.core.data.keys.PersistentDataKey;
import com.willfp.eco.core.data.keys.PersistentDataKeyType;
import com.willfp.eco.core.integrations.anticheat.AnticheatManager;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.NamespacedKeyUtils;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Tameable;
import org.bukkit.projectiles.ProjectileSource;

public final class PlayerUtils {
    private static final PersistentDataKey<String> PLAYER_NAME_KEY = new PersistentDataKey<String>(NamespacedKeyUtils.createEcoKey("player_name"), PersistentDataKeyType.STRING, "Unknown Player");

    @NotNull
    public static Audience getAudience(@NotNull Player player) {
        BukkitAudiences adventure = Eco.get().getAdventure();
        if (Prerequisite.HAS_PAPER.isMet()) {
            if (player instanceof Audience) {
                return (Audience)player;
            }
            return Audience.empty();
        }
        if (adventure == null) {
            return Audience.empty();
        }
        return adventure.player(player);
    }

    @NotNull
    public static Audience getAudience(@NotNull CommandSender sender) {
        BukkitAudiences adventure = Eco.get().getAdventure();
        if (Prerequisite.HAS_PAPER.isMet()) {
            if (sender instanceof Audience) {
                return (Audience)sender;
            }
            return Audience.empty();
        }
        if (adventure == null) {
            return Audience.empty();
        }
        return adventure.sender(sender);
    }

    public static String getSavedDisplayName(@NotNull OfflinePlayer player) {
        PlayerProfile profile2;
        String saved;
        if (player instanceof Player) {
            Player onlinePlayer = (Player)player;
            PlayerUtils.updateSavedDisplayName(onlinePlayer);
        }
        if ((saved = (profile2 = PlayerProfile.load(player)).read(PLAYER_NAME_KEY)).equals(PLAYER_NAME_KEY.getDefaultValue())) {
            return player.getName();
        }
        return saved;
    }

    public static void updateSavedDisplayName(@NotNull Player player) {
        PlayerProfile profile2 = PlayerProfile.load((OfflinePlayer)player);
        profile2.write(PLAYER_NAME_KEY, player.getDisplayName());
    }

    public static void runExempted(@NotNull Player player, @NotNull Consumer<Player> action) {
        try {
            AnticheatManager.exemptPlayer(player);
            action.accept(player);
        }
        finally {
            AnticheatManager.unexemptPlayer(player);
        }
    }

    public static void runExempted(@NotNull Player player, @NotNull Runnable action) {
        try {
            AnticheatManager.exemptPlayer(player);
            action.run();
        }
        finally {
            AnticheatManager.unexemptPlayer(player);
        }
    }

    @Nullable
    public static Player tryAsPlayer(@Nullable Entity entity) {
        Tameable tameable;
        AnimalTamer tamer;
        Projectile projectile;
        ProjectileSource shooter;
        if (entity == null) {
            return null;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        if (entity instanceof Projectile && (shooter = (projectile = (Projectile)entity).getShooter()) instanceof Player) {
            Player player = (Player)shooter;
            return player;
        }
        if (entity instanceof Tameable && (tamer = (tameable = (Tameable)entity).getOwner()) instanceof Player) {
            Player player = (Player)tamer;
            return player;
        }
        return null;
    }

    private PlayerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

