/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonSyntaxException;
import com.willfp.eco.core.Eco;
import com.willfp.eco.core.integrations.placeholder.PlaceholderManager;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.NumberUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.ChatColor;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Player;

public final class StringUtils {
    private static final List<Pattern> GRADIENT_PATTERNS = new ImmutableList.Builder().add((Object)Pattern.compile("<GRADIENT:([0-9A-Fa-f]{6})>(.*?)</GRADIENT:([0-9A-Fa-f]{6})>", 2)).add((Object)Pattern.compile("<GRADIENT:#([0-9A-Fa-f]{6})>(.*?)</GRADIENT:#([0-9A-Fa-f]{6})>", 2)).add((Object)Pattern.compile("<G:([0-9A-Fa-f]{6})>(.*?)</G:([0-9A-Fa-f]{6})>", 2)).add((Object)Pattern.compile("<G:#([0-9A-Fa-f]{6})>(.*?)</G:#([0-9A-Fa-f]{6})>", 2)).add((Object)Pattern.compile("<G#([0-9A-Fa-f]{6})>(.*?)</G#([0-9A-Fa-f]{6})>", 2)).add((Object)Pattern.compile("<#:([0-9A-Fa-f]{6})>(.*?)</#:([0-9A-Fa-f]{6})>")).add((Object)Pattern.compile("\\{#:([0-9A-Fa-f]{6})}(.*?)\\{/#:([0-9A-Fa-f]{6})}")).add((Object)Pattern.compile("\\{#([0-9A-Fa-f]{6})>}(.*?)\\{#([0-9A-Fa-f]{6})<}")).build();
    private static final List<Pattern> HEX_PATTERNS = new ImmutableList.Builder().add((Object)Pattern.compile("&#([A-Fa-f0-9]{6})")).add((Object)Pattern.compile("\\{#([A-Fa-f0-9]{6})}")).add((Object)Pattern.compile("<#([A-Fa-f0-9]{6})>")).build();
    private static final LegacyComponentSerializer LEGACY_COMPONENT_SERIALIZER = LegacyComponentSerializer.builder().character('\u00a7').useUnusualXRepeatedCharacterHexFormat().hexColors().build();
    private static final GsonComponentSerializer GSON_COMPONENT_SERIALIZER = GsonComponentSerializer.builder().emitLegacyHoverEvent().build();
    private static final LoadingCache<String, String> STRING_FORMAT_CACHE = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build(StringUtils::processFormatting);
    private static final Cache<String, Component> JSON_TO_COMPONENT = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
    private static final Cache<Component, String> COMPONENT_TO_JSON = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
    private static final Cache<String, Component> LEGACY_TO_COMPONENT = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
    private static final Cache<Component, String> COMPONENT_TO_LEGACY = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
    private static final String EMPTY_JSON = (String)GSON_COMPONENT_SERIALIZER.serialize(Component.empty());
    private static final Map<String, ChatColor> COLOR_MAP = new ImmutableMap.Builder().put((Object)"&l", (Object)ChatColor.BOLD).put((Object)"&o", (Object)ChatColor.ITALIC).put((Object)"&n", (Object)ChatColor.UNDERLINE).put((Object)"&m", (Object)ChatColor.STRIKETHROUGH).put((Object)"&k", (Object)ChatColor.MAGIC).put((Object)"\u00a7l", (Object)ChatColor.BOLD).put((Object)"\u00a7o", (Object)ChatColor.ITALIC).put((Object)"\u00a7n", (Object)ChatColor.UNDERLINE).put((Object)"\u00a7m", (Object)ChatColor.STRIKETHROUGH).put((Object)"\u00a7k", (Object)ChatColor.MAGIC).build();
    private static final LoadingCache<String, Pattern> SPACE_AROUND_CHARACTER = Caffeine.newBuilder().build(character -> Pattern.compile("( " + Pattern.quote(character) + " )"));

    @NotNull
    public static List<String> formatList(@NotNull List<String> list) {
        return StringUtils.formatList(list, (Player)null);
    }

    @NotNull
    public static List<String> formatList(@NotNull List<String> list, @Nullable Player player) {
        return StringUtils.formatList(list, player, FormatOption.WITH_PLACEHOLDERS);
    }

    @NotNull
    public static List<String> formatList(@NotNull List<String> list, @NotNull FormatOption option) {
        return StringUtils.formatList(list, null, option);
    }

    @NotNull
    public static List<String> formatList(@NotNull List<String> list, @Nullable Player player, @NotNull FormatOption option) {
        ArrayList<String> translated = new ArrayList<String>();
        for (String string : list) {
            translated.add(StringUtils.format(string, player, option));
        }
        return translated;
    }

    @NotNull
    public static List<String> formatList(@NotNull List<String> list, @NotNull PlaceholderContext context) {
        ArrayList<String> translated = new ArrayList<String>();
        for (String string : list) {
            translated.add(StringUtils.format(string, context));
        }
        return translated;
    }

    @NotNull
    public static String format(@NotNull String message) {
        return StringUtils.format(message, (Player)null);
    }

    @NotNull
    public static String format(@NotNull String message, @Nullable Player player) {
        return StringUtils.format(message, player, FormatOption.WITH_PLACEHOLDERS);
    }

    @NotNull
    public static String format(@NotNull String message, @NotNull FormatOption option) {
        return StringUtils.format(message, null, option);
    }

    @NotNull
    public static Component formatToComponent(@NotNull String message) {
        return StringUtils.formatToComponent(message, (Player)null);
    }

    @NotNull
    public static Component formatToComponent(@NotNull String message, @Nullable Player player) {
        return StringUtils.formatToComponent(message, player, FormatOption.WITH_PLACEHOLDERS);
    }

    @NotNull
    public static Component formatToComponent(@NotNull String message, @NotNull FormatOption option) {
        return StringUtils.formatToComponent(message, null, option);
    }

    @NotNull
    public static Component formatToComponent(@NotNull String message, @Nullable Player player, @NotNull FormatOption option) {
        return StringUtils.toComponent(StringUtils.format(message, player, option));
    }

    @NotNull
    public static String format(@NotNull String message, @Nullable Player player, @NotNull FormatOption option) {
        if (option == FormatOption.WITH_PLACEHOLDERS) {
            return StringUtils.format(message, new PlaceholderContext(player));
        }
        return STRING_FORMAT_CACHE.get(message);
    }

    @NotNull
    public static Component formatToComponent(@NotNull String message, @NotNull PlaceholderContext context) {
        return StringUtils.toComponent(StringUtils.format(message, context));
    }

    @NotNull
    public static String format(@NotNull String message, @NotNull PlaceholderContext context) {
        String processedMessage = message;
        processedMessage = PlaceholderManager.translatePlaceholders(processedMessage, context);
        return STRING_FORMAT_CACHE.get(processedMessage);
    }

    private static String processFormatting(@NotNull String message) {
        String processedMessage = message;
        processedMessage = StringUtils.translateMiniMessage(processedMessage);
        processedMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)processedMessage);
        processedMessage = StringUtils.translateGradients(processedMessage);
        processedMessage = StringUtils.translateHexColorCodes(processedMessage);
        return processedMessage;
    }

    private static String translateMiniMessage(@NotNull String message) {
        return Eco.get().formatMiniMessage(message);
    }

    private static String translateHexColorCodes(@NotNull String message) {
        String processedMessage = message;
        for (Pattern pattern : HEX_PATTERNS) {
            processedMessage = StringUtils.translateHexColorCodes(processedMessage, pattern);
        }
        return processedMessage;
    }

    private static String translateHexColorCodes(@NotNull String message, @NotNull Pattern pattern) {
        Matcher matcher = pattern.matcher(message);
        StringBuilder builder = new StringBuilder(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(builder, "\u00a7x\u00a7" + group.charAt(0) + "\u00a7" + group.charAt(1) + "\u00a7" + group.charAt(2) + "\u00a7" + group.charAt(3) + "\u00a7" + group.charAt(4) + "\u00a7" + group.charAt(5));
        }
        return matcher.appendTail(builder).toString();
    }

    private static String processGradients(@NotNull String string, @NotNull Color start, @NotNull Color end) {
        String processedString = string;
        ArrayList<ChatColor> modifiers = new ArrayList<ChatColor>();
        for (Map.Entry<String, ChatColor> entry : COLOR_MAP.entrySet()) {
            if (processedString.contains(entry.getKey())) {
                modifiers.add(entry.getValue());
            }
            processedString = processedString.replace(entry.getKey(), "");
        }
        StringBuilder stringBuilder = new StringBuilder();
        ChatColor[] colors = StringUtils.getGradientColors(start, end, processedString.length());
        String[] characters = processedString.split("");
        for (int i = 0; i < processedString.length(); ++i) {
            stringBuilder.append(colors[i]);
            modifiers.forEach(stringBuilder::append);
            stringBuilder.append(characters[i]);
        }
        return stringBuilder.toString();
    }

    private static ChatColor[] getGradientColors(@NotNull Color start, @NotNull Color end, int step) {
        ChatColor[] colors = new ChatColor[step];
        if (step <= 1) {
            return colors;
        }
        int stepR = Math.abs(start.getRed() - end.getRed()) / (step - 1);
        int stepG = Math.abs(start.getGreen() - end.getGreen()) / (step - 1);
        int stepB = Math.abs(start.getBlue() - end.getBlue()) / (step - 1);
        int[] direction = new int[]{start.getRed() < end.getRed() ? 1 : -1, start.getGreen() < end.getGreen() ? 1 : -1, start.getBlue() < end.getBlue() ? 1 : -1};
        for (int i = 0; i < step; ++i) {
            Color color = new Color(start.getRed() + stepR * i * direction[0], start.getGreen() + stepG * i * direction[1], start.getBlue() + stepB * i * direction[2]);
            colors[i] = ChatColor.of((Color)color);
        }
        return colors;
    }

    private static String translateGradients(@NotNull String string) {
        String processedString = string;
        for (Pattern pattern : GRADIENT_PATTERNS) {
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                String start = matcher.group(1);
                String end = matcher.group(3);
                String content = matcher.group(2);
                processedString = processedString.replace(matcher.group(), StringUtils.processGradients(content, new Color(Integer.parseInt(start, 16)), new Color(Integer.parseInt(end, 16))));
            }
        }
        return processedString;
    }

    @NotNull
    public static String toNiceString(@Nullable Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Integer) {
            return ((Integer)object).toString();
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Double) {
            return NumberUtils.format((Double)object);
        }
        if (object instanceof Collection) {
            Collection c = (Collection)object;
            return c.stream().map(StringUtils::toNiceString).collect(Collectors.joining(", "));
        }
        return String.valueOf(object);
    }

    @NotNull
    public static String removePrefix(@NotNull String string, @NotNull String prefix) {
        if (string.startsWith(prefix)) {
            return string.substring(prefix.length());
        }
        return string;
    }

    @NotNull
    public static String legacyToJson(@Nullable String legacy) {
        return StringUtils.componentToJson(StringUtils.toComponent(legacy));
    }

    @NotNull
    public static String jsonToLegacy(@Nullable String json) {
        return StringUtils.toLegacy(StringUtils.jsonToComponent(json));
    }

    @NotNull
    public static String componentToJson(@Nullable Component component) {
        if (component == null) {
            return EMPTY_JSON;
        }
        return COMPONENT_TO_JSON.get(component, it -> {
            try {
                return (String)GSON_COMPONENT_SERIALIZER.serialize(((TextComponent)Component.empty().decoration(TextDecoration.ITALIC, false)).append((Component)it));
            }
            catch (JsonSyntaxException e) {
                return (String)GSON_COMPONENT_SERIALIZER.serialize(Component.empty());
            }
        });
    }

    @NotNull
    public static Component jsonToComponent(@Nullable String json) {
        if (json == null || json.isEmpty()) {
            return Component.empty();
        }
        return JSON_TO_COMPONENT.get(json, it -> {
            try {
                return GSON_COMPONENT_SERIALIZER.deserialize(it);
            }
            catch (JsonSyntaxException e) {
                return Component.empty();
            }
        });
    }

    @NotNull
    public static Component toComponent(@Nullable String legacy) {
        return LEGACY_TO_COMPONENT.get(legacy == null ? "" : legacy, LEGACY_COMPONENT_SERIALIZER::deserialize);
    }

    @NotNull
    public static String toLegacy(@NotNull Component component) {
        return COMPONENT_TO_LEGACY.get(component, LEGACY_COMPONENT_SERIALIZER::serialize);
    }

    @NotNull
    public static String[] parseTokens(@NotNull String lookup) {
        char[] chars = lookup.toCharArray();
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder tokenBuilder = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == ' ') {
                tokens.add(tokenBuilder.toString());
                tokenBuilder.setLength(0);
                continue;
            }
            if (chars[i] == '\"') {
                ++i;
                while (chars[i] != '\"') {
                    if (chars[i] == '\\') {
                        ++i;
                    }
                    tokenBuilder.append(chars[i]);
                    ++i;
                }
                continue;
            }
            tokenBuilder.append(chars[i]);
        }
        tokens.add(tokenBuilder.toString());
        return tokens.toArray(new String[0]);
    }

    @NotNull
    public static String[] splitAround(@NotNull String input, @NotNull String separator) {
        return SPACE_AROUND_CHARACTER.get(separator).split(input);
    }

    @NotNull
    public static String createProgressBar(char character, int bars, double progress, @NotNull String completeFormat, @NotNull String inProgressFormat, @NotNull String incompleteFormat) {
        Validate.isTrue((progress >= 0.0 && progress <= 1.0 ? 1 : 0) != 0, (String)"Progress must be between 0 and 1!");
        Validate.isTrue((bars > 1 ? 1 : 0) != 0, (String)"Must have at least 2 bars!");
        String completeColor = StringUtils.format(completeFormat);
        String inProgressColor = StringUtils.format(inProgressFormat);
        String incompleteColor = StringUtils.format(incompleteFormat);
        StringBuilder builder = new StringBuilder();
        if (progress == 1.0) {
            builder.append(completeColor);
            builder.append(String.valueOf(character).repeat(bars));
            return builder.toString();
        }
        int completeBars = (int)Math.floor(progress * (double)bars);
        int incompleteBars = bars - completeBars - 1;
        if (completeBars > 0) {
            builder.append(completeColor).append(String.valueOf(character).repeat(completeBars));
        }
        builder.append(inProgressColor).append(character);
        if (incompleteBars > 0) {
            builder.append(incompleteColor).append(String.valueOf(character).repeat(incompleteBars));
        }
        return builder.toString();
    }

    @NotNull
    public static String replaceQuickly(@NotNull String input, @NotNull String target, @NotNull String replacement) {
        int targetLength = target.length();
        int count2 = 0;
        int index = input.indexOf(target);
        while (index != -1) {
            ++count2;
            index = input.indexOf(target, index + targetLength);
        }
        if (count2 == 0) {
            return input;
        }
        int replacementLength = replacement.length();
        int inputLength = input.length();
        int newSize = inputLength + (replacementLength - targetLength) * count2;
        StringBuilder result2 = new StringBuilder(newSize);
        int start = 0;
        int index2 = input.indexOf(target);
        while (index2 != -1) {
            result2.append(input, start, index2);
            result2.append(replacement);
            start = index2 + targetLength;
            index2 = input.indexOf(target, start);
        }
        result2.append(input, start, inputLength);
        return result2.toString();
    }

    @NotNull
    public static List<String> lineWrap(@NotNull List<String> input, int lineLength) {
        return StringUtils.lineWrap(input, lineLength, true);
    }

    @NotNull
    public static List<String> lineWrap(@NotNull List<String> input, int lineLength, boolean preserveMargin) {
        return input.stream().flatMap(line -> StringUtils.lineWrap(line, lineLength, preserveMargin).stream()).toList();
    }

    @NotNull
    public static List<String> lineWrap(@NotNull String input, int lineLength) {
        return StringUtils.lineWrap(input, lineLength, true);
    }

    @NotNull
    public static List<String> lineWrap(@NotNull String input, int lineLength, boolean preserveMargin) {
        int margin = preserveMargin ? StringUtils.getMargin(input) : 0;
        TextComponent space = Component.text(" ");
        Component asComponent = StringUtils.toComponent(input);
        ArrayList<TextComponent> children2 = new ArrayList<TextComponent>();
        if (asComponent instanceof TextComponent) {
            children2.add((TextComponent)asComponent);
        }
        for (Component component : asComponent.children()) {
            children2.add((TextComponent)component);
        }
        ArrayList<TextComponent> letters = new ArrayList<TextComponent>();
        for (TextComponent child : children2) {
            for (char c : child.content().toCharArray()) {
                letters.add((TextComponent)Component.text(c).mergeStyle(child));
            }
        }
        ArrayList<Component> arrayList = new ArrayList<Component>();
        ArrayList<TextComponent> currentLine = new ArrayList<TextComponent>();
        boolean isFirstLine = true;
        for (TextComponent letter : letters) {
            if (currentLine.size() > lineLength && letter.content().isBlank()) {
                arrayList.add(Component.join(JoinConfiguration.noSeparators(), currentLine));
                currentLine.clear();
                isFirstLine = false;
                continue;
            }
            if (currentLine.isEmpty() && !isFirstLine && preserveMargin) {
                for (int i = 0; i < margin; ++i) {
                    currentLine.add(space);
                }
            }
            currentLine.add(letter);
        }
        arrayList.add(Component.join(JoinConfiguration.noSeparators(), currentLine));
        return arrayList.stream().map(StringUtils::toLegacy).collect(Collectors.toList());
    }

    public static int getMargin(@NotNull String input) {
        return input.indexOf(input.trim());
    }

    private StringUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum FormatOption {
        WITH_PLACEHOLDERS,
        WITHOUT_PLACEHOLDERS;

    }
}

