/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public final class TeamUtils {
    private static final BiMap<ChatColor, Team> CHAT_COLOR_TEAMS = HashBiMap.create();
    private static final Scoreboard SCOREBOARD = Objects.requireNonNull(Bukkit.getScoreboardManager()).getMainScoreboard();

    @NotNull
    public static Team fromChatColor(@NotNull ChatColor color) {
        if (CHAT_COLOR_TEAMS.containsKey((Object)color)) {
            return (Team)CHAT_COLOR_TEAMS.get((Object)color);
        }
        Team team = !SCOREBOARD.getTeams().stream().map(Team::getName).toList().contains("EC-" + color.name()) ? SCOREBOARD.registerNewTeam("EC-" + color.name()) : SCOREBOARD.getTeam("EC-" + color.name());
        assert (team != null);
        team.setColor(color);
        CHAT_COLOR_TEAMS.forcePut((Object)color, (Object)team);
        return team;
    }

    private TeamUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        for (ChatColor value : ChatColor.values()) {
            TeamUtils.fromChatColor(value);
        }
    }
}

