/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.reactive;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.libs.reactivestreams.Subscriber;
import com.willfp.eco.libs.reactivestreams.Subscription;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.Volatile;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.BufferedChannel;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\b\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0015\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\rH\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016R\t\u0010\u0007\u001a\u00020\bX\u0082\u0004R\u0011\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkotlinx/coroutines/reactive/SubscriptionChannel;", "T", "Lkotlinx/coroutines/channels/BufferedChannel;", "Lcom/willfp/eco/libs/reactivestreams/Subscriber;", "request", "", "(I)V", "_requested", "Lkotlinx/atomicfu/AtomicInt;", "_subscription", "Lkotlinx/atomicfu/AtomicRef;", "Lcom/willfp/eco/libs/reactivestreams/Subscription;", "onClosedIdempotent", "", "onComplete", "onError", "e", "", "onNext", "t", "(Ljava/lang/Object;)V", "onReceiveDequeued", "onReceiveEnqueued", "onSubscribe", "s", "kotlinx-coroutines-reactive"})
@SourceDebugExtension(value={"SMAP\nChannel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Channel.kt\nkotlinx/coroutines/reactive/SubscriptionChannel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
final class SubscriptionChannel<T>
extends BufferedChannel<T>
implements Subscriber<T> {
    private final int request;
    @Volatile
    @Nullable
    private volatile Object _subscription;
    @Volatile
    private volatile int _requested;
    @NotNull
    private static final AtomicReferenceFieldUpdater _subscription$FU = AtomicReferenceFieldUpdater.newUpdater(SubscriptionChannel.class, Object.class, "_subscription");
    @NotNull
    private static final AtomicIntegerFieldUpdater _requested$FU = AtomicIntegerFieldUpdater.newUpdater(SubscriptionChannel.class, "_requested");

    public SubscriptionChannel(int request) {
        super(Integer.MAX_VALUE, null, 2, null);
        this.request = request;
        if (!(this.request >= 0)) {
            boolean bl = false;
            String string = "Invalid request size: " + this.request;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void onReceiveEnqueued() {
        SubscriptionChannel subscriptionChannel = this;
        AtomicIntegerFieldUpdater atomicfu$handler$iv = _requested$FU;
        boolean $i$f$loop$atomicfu = false;
        while (true) {
            int wasRequested = atomicfu$handler$iv.get(this);
            boolean bl = false;
            Subscription subscription = (Subscription)_subscription$FU.get(this);
            int needRequested = wasRequested - 1;
            if (subscription != null && needRequested < 0) {
                if (wasRequested != this.request && !_requested$FU.compareAndSet(this, wasRequested, this.request)) continue;
                subscription.request(this.request - needRequested);
                return;
            }
            if (_requested$FU.compareAndSet(this, wasRequested, needRequested)) break;
        }
    }

    @Override
    public void onReceiveDequeued() {
        _requested$FU.incrementAndGet(this);
    }

    @Override
    public void onClosedIdempotent() {
        block0: {
            Subscription subscription = _subscription$FU.getAndSet(this, null);
            if (subscription == null) break block0;
            subscription.cancel();
        }
    }

    @Override
    public void onSubscribe(@NotNull Subscription s2) {
        int wasRequested;
        _subscription$FU.set(this, s2);
        do {
            if (this.isClosedForSend()) {
                s2.cancel();
                return;
            }
            wasRequested = _requested$FU.get(this);
            if (wasRequested < this.request) continue;
            return;
        } while (!_requested$FU.compareAndSet(this, wasRequested, this.request));
        s2.request(this.request - wasRequested);
    }

    @Override
    public void onNext(T t2) {
        _requested$FU.decrementAndGet(this);
        this.trySend-JP2dKIU(t2);
    }

    @Override
    public void onComplete() {
        this.close(null);
    }

    @Override
    public void onError(@NotNull Throwable e) {
        this.close(e);
    }

    private final void loop$atomicfu(AtomicIntegerFieldUpdater atomicfu$handler, Function1<? super Integer, Unit> atomicfu$action, Object atomicfu$dispatchReceiver) {
        boolean $i$f$loop$atomicfu = false;
        while (true) {
            int n = atomicfu$handler.get(atomicfu$dispatchReceiver);
            atomicfu$action.invoke((Integer)n);
        }
    }
}

