/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/exposed/sql/LongColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "()V", "sqlType", "", "valueFromDB", "", "value", "", "(Ljava/lang/Object;)Ljava/lang/Long;", "exposed-core"})
public final class LongColumnType
extends ColumnType {
    public LongColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().longType();
    }

    @Override
    @NotNull
    public Long valueFromDB(@NotNull Object value) {
        long l;
        Intrinsics.checkNotNullParameter(value, "value");
        Object object = value;
        if (object instanceof Long) {
            l = ((Number)value).longValue();
        } else if (object instanceof Number) {
            l = ((Number)value).longValue();
        } else if (object instanceof String) {
            l = Long.parseLong((String)value);
        } else {
            throw new IllegalStateException(("Unexpected value of type Long: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return l;
    }
}

