/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import org.jetbrains.exposed.sql.SchemaKt;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\f\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\fJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u001a\u0010\u000eR\u0015\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u001b\u0010\u000eR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u001c\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u001d\u0010\u000e\u00a8\u0006 "}, d2={"Lorg/jetbrains/exposed/sql/Sequence;", "", "name", "", "startWith", "", "incrementBy", "minValue", "maxValue", "cycle", "", "cache", "(Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Boolean;Ljava/lang/Long;)V", "getCache", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getCycle", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "ddl", "", "getDdl", "()Ljava/util/List;", "identifier", "getIdentifier", "()Ljava/lang/String;", "getIncrementBy", "getMaxValue", "getMinValue", "getStartWith", "createStatement", "dropStatement", "exposed-core"})
public final class Sequence {
    @NotNull
    private final String name;
    @Nullable
    private final Long startWith;
    @Nullable
    private final Long incrementBy;
    @Nullable
    private final Long minValue;
    @Nullable
    private final Long maxValue;
    @Nullable
    private final Boolean cycle;
    @Nullable
    private final Long cache;

    public Sequence(@NotNull String name, @Nullable Long startWith, @Nullable Long incrementBy, @Nullable Long minValue, @Nullable Long maxValue, @Nullable Boolean cycle, @Nullable Long cache2) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.name = name;
        this.startWith = startWith;
        this.incrementBy = incrementBy;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.cycle = cycle;
        this.cache = cache2;
    }

    public /* synthetic */ Sequence(String string, Long l, Long l2, Long l3, Long l4, Boolean bl, Long l5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = null;
        }
        if ((n & 4) != 0) {
            l2 = null;
        }
        if ((n & 8) != 0) {
            l3 = null;
        }
        if ((n & 0x10) != 0) {
            l4 = null;
        }
        if ((n & 0x20) != 0) {
            bl = null;
        }
        if ((n & 0x40) != 0) {
            l5 = null;
        }
        this(string, l, l2, l3, l4, bl, l5);
    }

    @Nullable
    public final Long getStartWith() {
        return this.startWith;
    }

    @Nullable
    public final Long getIncrementBy() {
        return this.incrementBy;
    }

    @Nullable
    public final Long getMinValue() {
        return this.minValue;
    }

    @Nullable
    public final Long getMaxValue() {
        return this.maxValue;
    }

    @Nullable
    public final Boolean getCycle() {
        return this.cycle;
    }

    @Nullable
    public final Long getCache() {
        return this.cache;
    }

    @NotNull
    public final String getIdentifier() {
        return TransactionManager.Companion.current().getDb().getIdentifierManager().cutIfNecessaryAndQuote(this.name);
    }

    @NotNull
    public final List<String> getDdl() {
        return this.createStatement();
    }

    @NotNull
    public final List<String> createStatement() {
        StringBuilder stringBuilder;
        if (!DefaultKt.getCurrentDialect().getSupportsCreateSequence()) {
            throw new UnsupportedByDialectException("The current dialect doesn't support create sequence statement", DefaultKt.getCurrentDialect());
        }
        StringBuilder $this$createStatement_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createStatement_u24lambda_u2d0.append("CREATE SEQUENCE ");
        if (DefaultKt.getCurrentDialect().getSupportsIfNotExists()) {
            $this$createStatement_u24lambda_u2d0.append("IF NOT EXISTS ");
        }
        $this$createStatement_u24lambda_u2d0.append(this.getIdentifier());
        SchemaKt.appendIfNotNull($this$createStatement_u24lambda_u2d0, " START WITH", this.getStartWith());
        SchemaKt.appendIfNotNull($this$createStatement_u24lambda_u2d0, " INCREMENT BY", this.getIncrementBy());
        SchemaKt.appendIfNotNull($this$createStatement_u24lambda_u2d0, " MINVALUE", this.getMinValue());
        SchemaKt.appendIfNotNull($this$createStatement_u24lambda_u2d0, " MAXVALUE", this.getMaxValue());
        if (Intrinsics.areEqual(this.getCycle(), true)) {
            $this$createStatement_u24lambda_u2d0.append(" CYCLE");
        }
        SchemaKt.appendIfNotNull($this$createStatement_u24lambda_u2d0, " CACHE", this.getCache());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        String createSequenceDDL = string;
        return CollectionsKt.listOf(createSequenceDDL);
    }

    @NotNull
    public final List<String> dropStatement() {
        StringBuilder stringBuilder;
        if (!DefaultKt.getCurrentDialect().getSupportsCreateSequence()) {
            throw new UnsupportedByDialectException("The current dialect doesn't support drop sequence statement", DefaultKt.getCurrentDialect());
        }
        StringBuilder $this$dropStatement_u24lambda_u2d1 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$dropStatement_u24lambda_u2d1.append("DROP SEQUENCE ");
        if (DefaultKt.getCurrentDialect().getSupportsIfNotExists()) {
            $this$dropStatement_u24lambda_u2d1.append("IF EXISTS ");
        }
        $this$dropStatement_u24lambda_u2d1.append(this.getIdentifier());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        String dropSequenceDDL = string;
        return CollectionsKt.listOf(dropSequenceDDL);
    }
}

