/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.transactions;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.exceptions.ExposedSQLException;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.SqlLogger;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.jetbrains.exposed.sql.transactions.TransactionApiKt;
import org.jetbrains.exposed.sql.transactions.TransactionInterface;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a \u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001aR\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\n0\u0011\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\u0010\u0013\u001a-\u0010\u0014\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\n0\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017\u001aF\u0010\u0002\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\n0\u0011\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\u0010\u0018\u001a6\u0010\u0002\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\n0\u0011\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"closeStatementsAndConnection", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "handleSQLException", "e", "Ljava/sql/SQLException;", "repetitions", "", "inTopLevelTransaction", "T", "transactionIsolation", "repetitionAttempts", "db", "Lorg/jetbrains/exposed/sql/Database;", "outerTransaction", "statement", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(IILorg/jetbrains/exposed/sql/Database;Lorg/jetbrains/exposed/sql/Transaction;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "keepAndRestoreTransactionRefAfterRun", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "(IILorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "(Lorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "exposed-core"})
public final class ThreadLocalTransactionManagerKt {
    public static final <T> T transaction(@Nullable Database db, @NotNull Function1<? super Transaction, ? extends T> statement) {
        Intrinsics.checkNotNullParameter(statement, "statement");
        return ThreadLocalTransactionManagerKt.transaction(TransactionApiKt.getTransactionManager(db).getDefaultIsolationLevel(), TransactionApiKt.getTransactionManager(db).getDefaultRepetitionAttempts(), db, statement);
    }

    public static /* synthetic */ Object transaction$default(Database database, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.transaction(database, function1);
    }

    public static final <T> T transaction(int transactionIsolation, int repetitionAttempts, @Nullable Database db, @NotNull Function1<? super Transaction, ? extends T> statement) {
        Intrinsics.checkNotNullParameter(statement, "statement");
        return ThreadLocalTransactionManagerKt.keepAndRestoreTransactionRefAfterRun(db, new Function0<T>(db, transactionIsolation, statement, repetitionAttempts){
            final /* synthetic */ Database $db;
            final /* synthetic */ int $transactionIsolation;
            final /* synthetic */ Function1<Transaction, T> $statement;
            final /* synthetic */ int $repetitionAttempts;
            {
                this.$db = $db;
                this.$transactionIsolation = $transactionIsolation;
                this.$statement = $statement;
                this.$repetitionAttempts = $repetitionAttempts;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T invoke() {
                T t2;
                Transaction outer = TransactionManager.Companion.currentOrNull();
                if (outer != null && (this.$db == null || Intrinsics.areEqual(outer.getDb(), this.$db))) {
                    T t3;
                    TransactionManager outerManager = TransactionApiKt.getTransactionManager(outer.getDb());
                    Transaction transaction2 = outerManager.newTransaction(this.$transactionIsolation, outer);
                    try {
                        T it = t3 = this.$statement.invoke(transaction2);
                        boolean bl = false;
                        if (outer.getDb().getUseNestedTransactions()) {
                            transaction2.commit();
                        }
                    }
                    finally {
                        TransactionManager.Companion.resetCurrent(outerManager);
                    }
                    t2 = t3;
                } else {
                    T t4;
                    TransactionManager existingForDb;
                    Database database = this.$db;
                    TransactionManager transactionManager = existingForDb = database == null ? null : TransactionApiKt.getTransactionManager(database);
                    if (transactionManager == null) {
                        t4 = null;
                    } else {
                        Transaction transaction3 = transactionManager.currentOrNull();
                        if (transaction3 == null) {
                            t4 = null;
                        } else {
                            T t5;
                            Transaction transaction4 = transaction3;
                            Function1<Transaction, T> function1 = this.$statement;
                            Database database2 = this.$db;
                            Transaction transaction5 = transaction4;
                            boolean bl = false;
                            Transaction transaction6 = outer;
                            TransactionManager currentManager = TransactionApiKt.getTransactionManager((Database)(transaction6 == null ? null : transaction6.getDb()));
                            try {
                                TransactionManager.Companion.resetCurrent(existingForDb);
                                T it = t5 = function1.invoke(transaction5);
                                boolean bl2 = false;
                                if (database2.getUseNestedTransactions()) {
                                    transaction5.commit();
                                }
                            }
                            finally {
                                TransactionManager.Companion.resetCurrent(currentManager);
                            }
                            t4 = t5;
                        }
                    }
                    T t6 = t4;
                    t2 = t6 == null ? (T)ThreadLocalTransactionManagerKt.inTopLevelTransaction(this.$transactionIsolation, this.$repetitionAttempts, this.$db, null, this.$statement) : t6;
                }
                return t2;
            }
        });
    }

    public static /* synthetic */ Object transaction$default(int n, int n2, Database database, Function1 function1, int n3, Object object) {
        if ((n3 & 4) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.transaction(n, n2, database, function1);
    }

    public static final <T> T inTopLevelTransaction(int transactionIsolation, int repetitionAttempts, @Nullable Database db, @Nullable Transaction outerTransaction, @NotNull Function1<? super Transaction, ? extends T> statement) {
        Intrinsics.checkNotNullParameter(statement, "statement");
        return ThreadLocalTransactionManagerKt.keepAndRestoreTransactionRefAfterRun(db, new Function0<T>(outerTransaction, db, transactionIsolation, statement, repetitionAttempts){
            final /* synthetic */ Transaction $outerTransaction;
            final /* synthetic */ Database $db;
            final /* synthetic */ int $transactionIsolation;
            final /* synthetic */ Function1<Transaction, T> $statement;
            final /* synthetic */ int $repetitionAttempts;
            {
                this.$outerTransaction = $outerTransaction;
                this.$db = $db;
                this.$transactionIsolation = $transactionIsolation;
                this.$statement = $statement;
                this.$repetitionAttempts = $repetitionAttempts;
                super(0);
            }

            public final T invoke() {
                return (T)ThreadLocalTransactionManagerKt.access$inTopLevelTransaction$run(this.$outerTransaction, this.$db, this.$transactionIsolation, this.$statement, this.$repetitionAttempts);
            }
        });
    }

    public static /* synthetic */ Object inTopLevelTransaction$default(int n, int n2, Database database, Transaction transaction2, Function1 function1, int n3, Object object) {
        if ((n3 & 4) != 0) {
            database = null;
        }
        if ((n3 & 8) != 0) {
            transaction2 = null;
        }
        return ThreadLocalTransactionManagerKt.inTopLevelTransaction(n, n2, database, transaction2, function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T keepAndRestoreTransactionRefAfterRun(Database db, Function0<? extends T> block) {
        T t2;
        TransactionManager manager = TransactionApiKt.getTransactionManager(db);
        Transaction currentTransaction = manager.currentOrNull();
        try {
            t2 = block.invoke();
        }
        finally {
            manager.bindTransactionToThread(currentTransaction);
        }
        return t2;
    }

    static /* synthetic */ Object keepAndRestoreTransactionRefAfterRun$default(Database database, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.keepAndRestoreTransactionRefAfterRun(database, function0);
    }

    /*
     * WARNING - void declaration
     */
    public static final void handleSQLException(@NotNull SQLException e, @NotNull Transaction transaction2, int repetitions) {
        String string;
        String string2;
        ExposedSQLException exposedSQLException;
        Intrinsics.checkNotNullParameter(e, "e");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        ExposedSQLException exposedSQLException2 = exposedSQLException = e instanceof ExposedSQLException ? (ExposedSQLException)e : null;
        if (exposedSQLException2 == null) {
            string2 = null;
        } else {
            List<String> list = exposedSQLException2.causedByQueries();
            string2 = string = list == null ? null : CollectionsKt.joinToString$default(list, ";\n", null, null, 0, null, null, 62, null);
        }
        if (string2 == null) {
            string = String.valueOf(transaction2.getCurrentStatement());
        }
        String queriesToLog = string;
        String message = "Transaction attempt #" + repetitions + " failed: " + e.getMessage() + ". Statement(s): " + queriesToLog;
        ExposedSQLException exposedSQLException3 = exposedSQLException;
        if (exposedSQLException3 != null) {
            List<StatementContext> list = exposedSQLException3.getContexts();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void $this$forEach$iv2;
                    void $this$filterIsInstanceTo$iv$iv;
                    StatementContext it = (StatementContext)element$iv;
                    boolean bl = false;
                    Iterable $this$filterIsInstance$iv = transaction2.getInterceptors$exposed_core();
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof SqlLogger)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        SqlLogger logger = (SqlLogger)element$iv2;
                        boolean bl2 = false;
                        logger.log(it, transaction2);
                    }
                }
            }
        }
        SQLLogKt.getExposedLogger().warn(message, (Throwable)e);
        TransactionApiKt.rollbackLoggingException(transaction2, handleSQLException.2.INSTANCE);
    }

    public static final void closeStatementsAndConnection(@NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        PreparedStatementApi currentStatement = transaction2.getCurrentStatement();
        try {
            PreparedStatementApi preparedStatementApi = currentStatement;
            if (preparedStatementApi != null) {
                PreparedStatementApi it = preparedStatementApi;
                boolean bl = false;
                it.closeIfPossible();
                transaction2.setCurrentStatement(null);
            }
            transaction2.closeExecutedStatements();
        }
        catch (Exception e) {
            SQLLogKt.getExposedLogger().warn("Statements close failed", (Throwable)e);
        }
        TransactionInterface $this$closeLoggingException$iv = transaction2;
        boolean $i$f$closeLoggingException = false;
        try {
            $this$closeLoggingException$iv.close();
        }
        catch (Exception e$iv) {
            Exception it = e$iv;
            boolean bl = false;
            SQLLogKt.getExposedLogger().warn("Transaction close failed: " + it.getMessage() + ". Statement: " + currentStatement, (Throwable)it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T inTopLevelTransaction$run(Transaction $outerTransaction, Database $db, int $transactionIsolation, Function1<? super Transaction, ? extends T> $statement, int $repetitionAttempts) {
        TransactionManager transactionManager;
        int repetitions = 0;
        Transaction transaction2 = $outerTransaction;
        TransactionManager it = transactionManager = TransactionApiKt.getTransactionManager((Database)(transaction2 == null ? null : transaction2.getDb()));
        boolean bl = false;
        TransactionManager outerManager = it.currentOrNull() != null ? transactionManager : null;
        while (true) {
            if ($db != null) {
                boolean bl2 = false;
                TransactionManager m4 = TransactionApiKt.getTransactionManager($db);
                boolean bl3 = false;
                TransactionManager.Companion.resetCurrent(m4);
            }
            Transaction transaction3 = TransactionApiKt.getTransactionManager($db).newTransaction($transactionIsolation, $outerTransaction);
            try {
                Schema schema = transaction3.getDb().getConfig().getDefaultSchema();
                if (schema != null) {
                    Schema it2 = schema;
                    boolean bl4 = false;
                    SchemaUtils.setSchema$default(SchemaUtils.INSTANCE, it2, false, 2, null);
                }
                T answer = $statement.invoke(transaction3);
                transaction3.commit();
                T it3 = answer;
                return it3;
            }
            catch (SQLException e) {
                ThreadLocalTransactionManagerKt.handleSQLException(e, transaction3, repetitions);
                int it3 = repetitions;
                if ((repetitions = it3 + 1) < $repetitionAttempts) continue;
                throw e;
            }
            catch (Throwable e) {
                PreparedStatementApi currentStatement = transaction3.getCurrentStatement();
                TransactionApiKt.rollbackLoggingException(transaction3, (Function1<? super Exception, Unit>)new Function1<Exception, Unit>(currentStatement){
                    final /* synthetic */ PreparedStatementApi $currentStatement;
                    {
                        this.$currentStatement = $currentStatement;
                        super(1);
                    }

                    public final void invoke(@NotNull Exception it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        SQLLogKt.getExposedLogger().warn("Transaction rollback failed: " + it.getMessage() + ". Statement: " + this.$currentStatement, (Throwable)it);
                    }
                });
                throw e;
            }
            finally {
                TransactionManager.Companion.resetCurrent(outerManager);
                ThreadLocalTransactionManagerKt.closeStatementsAndConnection(transaction3);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ Object access$inTopLevelTransaction$run(Transaction $outerTransaction, Database $db, int $transactionIsolation, Function1 $statement, int $repetitionAttempts) {
        return ThreadLocalTransactionManagerKt.inTopLevelTransaction$run($outerTransaction, $db, $transactionIsolation, $statement, $repetitionAttempts);
    }
}

