/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionAlias;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016J$\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0014\u0010\u001e\u001a\u00020\u00042\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016J\b\u0010 \u001a\u00020\u0004H\u0016J\b\u0010!\u001a\u00020\u0004H\u0016J\b\u0010\"\u001a\u00020\u0004H\u0016J\b\u0010#\u001a\u00020\u0004H\u0016J\b\u0010$\u001a\u00020\u0004H\u0016J\b\u0010%\u001a\u00020\u0004H\u0016J\b\u0010&\u001a\u00020\u0004H\u0016J\u0010\u0010'\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0004H\u0016\u00a8\u0006*"}, d2={"Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "", "()V", "binaryType", "", "length", "", "blobType", "booleanFromStringToBoolean", "", "value", "booleanToStatementString", "bool", "booleanType", "byteType", "dateTimeType", "doubleType", "floatType", "integerAutoincType", "integerType", "longAutoincType", "longType", "precessOrderByClause", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "expression", "Lorg/jetbrains/exposed/sql/Expression;", "sortOrder", "Lorg/jetbrains/exposed/sql/SortOrder;", "processForDefaultValue", "e", "shortType", "textType", "timeType", "ubyteType", "uintegerType", "ulongType", "ushortType", "uuidToDB", "Ljava/util/UUID;", "uuidType", "exposed-core"})
public abstract class DataTypeProvider {
    @NotNull
    public String byteType() {
        return "TINYINT";
    }

    @NotNull
    public String ubyteType() {
        return "TINYINT";
    }

    @NotNull
    public String shortType() {
        return "SMALLINT";
    }

    @NotNull
    public String ushortType() {
        return "SMALLINT";
    }

    @NotNull
    public String integerType() {
        return "INT";
    }

    @NotNull
    public String uintegerType() {
        return "INT";
    }

    @NotNull
    public String integerAutoincType() {
        return "INT AUTO_INCREMENT";
    }

    @NotNull
    public String longType() {
        return "BIGINT";
    }

    @NotNull
    public String ulongType() {
        return "BIGINT";
    }

    @NotNull
    public String longAutoincType() {
        return "BIGINT AUTO_INCREMENT";
    }

    @NotNull
    public String floatType() {
        return "FLOAT";
    }

    @NotNull
    public String doubleType() {
        return "DOUBLE PRECISION";
    }

    @NotNull
    public String textType() {
        return "TEXT";
    }

    @NotNull
    public abstract String binaryType();

    @NotNull
    public String binaryType(int length) {
        return length == Integer.MAX_VALUE ? "VARBINARY(MAX)" : "VARBINARY(" + length + ')';
    }

    @NotNull
    public String blobType() {
        return "BLOB";
    }

    @NotNull
    public String uuidType() {
        return "BINARY(16)";
    }

    @NotNull
    public Object uuidToDB(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter(value, "value");
        byte[] byArray = ByteBuffer.allocate(16).putLong(value.getMostSignificantBits()).putLong(value.getLeastSignificantBits()).array();
        Intrinsics.checkNotNullExpressionValue(byArray, "allocate(16).putLong(val\u2026tSignificantBits).array()");
        return byArray;
    }

    @NotNull
    public String dateTimeType() {
        return "DATETIME";
    }

    @NotNull
    public String timeType() {
        return "TIME";
    }

    @NotNull
    public String booleanType() {
        return "BOOLEAN";
    }

    @NotNull
    public String booleanToStatementString(boolean bool) {
        String string = String.valueOf(bool).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toUpperCase(Locale.ROOT)");
        return string;
    }

    public boolean booleanFromStringToBoolean(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return Boolean.parseBoolean(value);
    }

    @NotNull
    public String processForDefaultValue(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return e instanceof LiteralOp ? String.valueOf(e) : (DefaultKt.getCurrentDialect() instanceof MysqlDialect ? String.valueOf(e) : (DefaultKt.getCurrentDialect() instanceof SQLServerDialect ? String.valueOf(e) : "" + '(' + e + ')'));
    }

    public void precessOrderByClause(@NotNull QueryBuilder queryBuilder, @NotNull Expression<?> expression, @NotNull SortOrder sortOrder) {
        Object object;
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter((Object)sortOrder, "sortOrder");
        Object[] objectArray = new Object[3];
        ExpressionAlias expressionAlias = expression instanceof ExpressionAlias ? (ExpressionAlias)expression : null;
        if (expressionAlias == null) {
            object = expression;
        } else {
            object = expressionAlias.getAlias();
            if (object == null) {
                object = expression;
            }
        }
        objectArray[0] = object;
        objectArray[1] = " ";
        objectArray[2] = sortOrder.getCode();
        ExpressionKt.append(queryBuilder, objectArray);
    }
}

