/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Join;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.StringColumnType;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.MysqlFunctionProvider;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0010\u0018\u00002\u00020\u0001:\u00044567B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J9\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J:\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0017\u0010\u001e\u001a\u00020\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010 J@\u0010!\u001a\u00020\b\"\n\b\u0000\u0010\"*\u0004\u0018\u00010\u00042\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0\n2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u000eH\u0016J8\u0010'\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u001e\u0010(\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d\u0012\u0006\u0012\u0004\u0018\u00010*0)0\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016JW\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-2\u001e\u0010.\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d\u0012\u0006\u0012\u0004\u0018\u00010*0)0\u001c2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010/2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u00100J6\u00101\u001a\b\u0012\u0004\u0012\u00020\u00110/\"\n\b\u0000\u0010\"*\u0004\u0018\u00010\u0004*\b\u0012\u0004\u0012\u0002H\"0\n2\u0006\u0010$\u001a\u00020\u00042\b\u00102\u001a\u0004\u0018\u000103H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00068"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlFunctionProvider;", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "()V", "DEFAULT_VALUE_EXPRESSION", "", "getDEFAULT_VALUE_EXPRESSION", "()Ljava/lang/String;", "cast", "", "expr", "Lorg/jetbrains/exposed/sql/Expression;", "type", "Lorg/jetbrains/exposed/sql/IColumnType;", "builder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "delete", "ignore", "", "table", "Lorg/jetbrains/exposed/sql/Table;", "where", "limit", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "(ZLorg/jetbrains/exposed/sql/Table;Ljava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "insert", "columns", "", "Lorg/jetbrains/exposed/sql/Column;", "random", "seed", "(Ljava/lang/Integer;)Ljava/lang/String;", "regexp", "T", "expr1", "pattern", "caseSensitive", "queryBuilder", "replace", "data", "Lkotlin/Pair;", "", "update", "targets", "Lorg/jetbrains/exposed/sql/Join;", "columnsAndValues", "Lorg/jetbrains/exposed/sql/Op;", "(Lorg/jetbrains/exposed/sql/Join;Ljava/util/List;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "match", "mode", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider$MatchMode;", "CharColumnType", "INSTANCE", "MATCH", "MysqlMatchMode", "exposed-core"})
public class MysqlFunctionProvider
extends FunctionProvider {
    @NotNull
    private final String DEFAULT_VALUE_EXPRESSION;

    public MysqlFunctionProvider() {
        this.DEFAULT_VALUE_EXPRESSION = "() VALUES ()";
    }

    @Override
    @NotNull
    public String random(@Nullable Integer seed) {
        StringBuilder stringBuilder = new StringBuilder().append("RAND(");
        Integer n = seed;
        String string = n == null ? null : n.toString();
        if (string == null) {
            string = "";
        }
        return stringBuilder.append(string).append(')').toString();
    }

    @Override
    @NotNull
    public <T extends String> Op<Boolean> match(@NotNull Expression<T> $this$match, @NotNull String pattern, @Nullable FunctionProvider.MatchMode mode) {
        Intrinsics.checkNotNullParameter($this$match, "<this>");
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        FunctionProvider.MatchMode matchMode = mode;
        if (matchMode == null) {
            matchMode = MysqlMatchMode.STRICT;
        }
        return new MATCH($this$match, pattern, matchMode);
    }

    @Override
    public <T extends String> void regexp(@NotNull Expression<T> expr1, @NotNull Expression<String> pattern, boolean caseSensitive, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr1, "expr1");
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        if (((MysqlDialect)DefaultKt.getCurrentDialect()).isMysql8$exposed_core()) {
            super.regexp(expr1, pattern, caseSensitive, queryBuilder);
        } else {
            queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr1, pattern){
                final /* synthetic */ Expression<T> $expr1;
                final /* synthetic */ Expression<String> $pattern;
                {
                    this.$expr1 = $expr1;
                    this.$pattern = $pattern;
                    super(1);
                }

                public final void invoke(@NotNull QueryBuilder $this$invoke) {
                    Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                    Object[] objectArray = new Object[]{this.$expr1, " REGEXP ", this.$pattern};
                    ExpressionKt.append($this$invoke, objectArray);
                }
            });
        }
    }

    @Override
    @NotNull
    public String replace(@NotNull Table table, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> data2, @NotNull Transaction transaction2) {
        QueryBuilder queryBuilder;
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        QueryBuilder builder = new QueryBuilder(true);
        String columns2 = CollectionsKt.joinToString$default(data2, null, null, null, 0, null, new Function1<Pair<? extends Column<?>, ? extends Object>, CharSequence>(transaction2){
            final /* synthetic */ Transaction $transaction;
            {
                this.$transaction = $transaction;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Pair<? extends Column<?>, ? extends Object> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$transaction.identity(it.getFirst());
            }
        }, 31, null);
        QueryBuilder $this$replace_u24lambda_u2d0 = queryBuilder = builder;
        boolean bl = false;
        QueryBuilder.appendTo$default($this$replace_u24lambda_u2d0, data2, null, null, null, (Function2)replace.values.1.1.INSTANCE, 7, null);
        String values2 = queryBuilder.toString();
        return "REPLACE INTO " + transaction2.identity(table) + " (" + columns2 + ") VALUES (" + values2 + ')';
    }

    @Override
    public void cast(@NotNull Expression<?> expr, @NotNull IColumnType type2, @NotNull QueryBuilder builder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(builder, "builder");
        if (type2 instanceof StringColumnType) {
            super.cast(expr, CharColumnType.INSTANCE, builder);
        } else {
            super.cast(expr, type2, builder);
        }
    }

    @Override
    @NotNull
    public String getDEFAULT_VALUE_EXPRESSION() {
        return this.DEFAULT_VALUE_EXPRESSION;
    }

    @Override
    @NotNull
    public String insert(boolean ignore, @NotNull Table table, @NotNull List<? extends Column<?>> columns2, @NotNull String expr, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(columns2, "columns");
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        String def = super.insert(false, table, columns2, expr, transaction2);
        return ignore ? StringsKt.replaceFirst$default(def, "INSERT", "INSERT IGNORE", false, 4, null) : def;
    }

    @Override
    @NotNull
    public String delete(boolean ignore, @NotNull Table table, @Nullable String where, @Nullable Integer limit, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        String def = super.delete(false, table, where, limit, transaction2);
        return ignore ? StringsKt.replaceFirst$default(def, "DELETE", "DELETE IGNORE", false, 4, null) : def;
    }

    @Override
    @NotNull
    public String update(@NotNull Join targets, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> columnsAndValues, @Nullable Integer limit, @Nullable Op<Boolean> where, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter(targets, "targets");
        Intrinsics.checkNotNullParameter(columnsAndValues, "columnsAndValues");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        QueryBuilder $this$update_u24lambda_u2d3 = new QueryBuilder(true);
        boolean bl = false;
        $this$update_u24lambda_u2d3.unaryPlus("UPDATE ");
        targets.describe(transaction2, $this$update_u24lambda_u2d3);
        $this$update_u24lambda_u2d3.unaryPlus(" SET ");
        ExpressionKt.appendTo$default(columnsAndValues, $this$update_u24lambda_u2d3, null, null, null, new Function2<QueryBuilder, Pair<? extends Column<?>, ? extends Object>, Unit>(transaction2){
            final /* synthetic */ Transaction $transaction;
            {
                this.$transaction = $transaction;
                super(2);
            }

            public final void invoke(@NotNull QueryBuilder $this$appendTo, @NotNull Pair<? extends Column<?>, ? extends Object> $dstr$col$value) {
                Intrinsics.checkNotNullParameter($this$appendTo, "$this$appendTo");
                Intrinsics.checkNotNullParameter($dstr$col$value, "$dstr$col$value");
                Column<?> col = $dstr$col$value.component1();
                Object value = $dstr$col$value.component2();
                $this$appendTo.append(Intrinsics.stringPlus(this.$transaction.fullIdentity(col), "="));
                $this$appendTo.registerArgument(col, value);
            }
        }, 14, null);
        Op<Boolean> op = where;
        if (op != null) {
            Op<Boolean> it = op;
            boolean bl2 = false;
            $this$update_u24lambda_u2d3.unaryPlus(" WHERE ");
            $this$update_u24lambda_u2d3.unaryPlus((Expression)it);
        }
        Integer n = limit;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl3 = false;
            $this$update_u24lambda_u2d3.unaryPlus(Intrinsics.stringPlus(" LIMIT ", it));
        }
        return $this$update_u24lambda_u2d3.toString();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlFunctionProvider$INSTANCE;", "Lorg/jetbrains/exposed/sql/vendors/MysqlFunctionProvider;", "()V", "exposed-core"})
    public static final class INSTANCE
    extends MysqlFunctionProvider {
        @NotNull
        public static final INSTANCE INSTANCE = new INSTANCE();

        private INSTANCE() {
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlFunctionProvider$MATCH;", "Lorg/jetbrains/exposed/sql/Op;", "", "expr", "Lorg/jetbrains/exposed/sql/Expression;", "pattern", "", "mode", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider$MatchMode;", "(Lorg/jetbrains/exposed/sql/Expression;Ljava/lang/String;Lorg/jetbrains/exposed/sql/vendors/FunctionProvider$MatchMode;)V", "getExpr", "()Lorg/jetbrains/exposed/sql/Expression;", "getMode", "()Lorg/jetbrains/exposed/sql/vendors/FunctionProvider$MatchMode;", "getPattern", "()Ljava/lang/String;", "toQueryBuilder", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "exposed-core"})
    private static final class MATCH
    extends Op<Boolean> {
        @NotNull
        private final Expression<?> expr;
        @NotNull
        private final String pattern;
        @NotNull
        private final FunctionProvider.MatchMode mode;

        public MATCH(@NotNull Expression<?> expr, @NotNull String pattern, @NotNull FunctionProvider.MatchMode mode) {
            Intrinsics.checkNotNullParameter(expr, "expr");
            Intrinsics.checkNotNullParameter(pattern, "pattern");
            Intrinsics.checkNotNullParameter(mode, "mode");
            this.expr = expr;
            this.pattern = pattern;
            this.mode = mode;
        }

        @NotNull
        public final Expression<?> getExpr() {
            return this.expr;
        }

        @NotNull
        public final String getPattern() {
            return this.pattern;
        }

        @NotNull
        public final FunctionProvider.MatchMode getMode() {
            return this.mode;
        }

        @Override
        public void toQueryBuilder(@NotNull QueryBuilder queryBuilder) {
            Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
            queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(this){
                final /* synthetic */ MATCH this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull QueryBuilder $this$invoke) {
                    Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                    Object[] objectArray = new Object[]{"MATCH(", this.this$0.getExpr(), ") AGAINST ('", this.this$0.getPattern(), "' ", this.this$0.getMode().mode(), ")"};
                    ExpressionKt.append($this$invoke, objectArray);
                }
            });
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlFunctionProvider$MysqlMatchMode;", "", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider$MatchMode;", "operator", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getOperator", "()Ljava/lang/String;", "mode", "STRICT", "NATURAL_LANGUAGE", "exposed-core"})
    private static final class MysqlMatchMode
    extends Enum<MysqlMatchMode>
    implements FunctionProvider.MatchMode {
        @NotNull
        private final String operator;
        public static final /* enum */ MysqlMatchMode STRICT = new MysqlMatchMode("IN BOOLEAN MODE");
        public static final /* enum */ MysqlMatchMode NATURAL_LANGUAGE = new MysqlMatchMode("IN NATURAL LANGUAGE MODE");
        private static final /* synthetic */ MysqlMatchMode[] $VALUES;

        private MysqlMatchMode(String operator) {
            this.operator = operator;
        }

        @NotNull
        public final String getOperator() {
            return this.operator;
        }

        @Override
        @NotNull
        public String mode() {
            return this.operator;
        }

        public static MysqlMatchMode[] values() {
            return (MysqlMatchMode[])$VALUES.clone();
        }

        public static MysqlMatchMode valueOf(String value) {
            return Enum.valueOf(MysqlMatchMode.class, value);
        }

        static {
            $VALUES = mysqlMatchModeArray = new MysqlMatchMode[]{MysqlMatchMode.STRICT, MysqlMatchMode.NATURAL_LANGUAGE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlFunctionProvider$CharColumnType;", "Lorg/jetbrains/exposed/sql/StringColumnType;", "()V", "sqlType", "", "exposed-core"})
    private static final class CharColumnType
    extends StringColumnType {
        @NotNull
        public static final CharColumnType INSTANCE = new CharColumnType();

        private CharColumnType() {
            super(null, 1, null);
        }

        @Override
        @NotNull
        public String sqlType() {
            return "CHAR";
        }
    }
}

