/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.PostgreSQLFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J(\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0014J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0014\u0010\u000f\u001a\u00020\u00042\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/exposed/sql/vendors/PostgreSQLDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "supportsOrderByNullsFirstLast", "", "getSupportsOrderByNullsFirstLast", "()Z", "createDatabase", "", "name", "createIndexWithType", "table", "columns", "type", "dropDatabase", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "modifyColumn", "", "column", "Lorg/jetbrains/exposed/sql/Column;", "columnDiff", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "setSchema", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "Companion", "exposed-core"})
public class PostgreSQLDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsOrderByNullsFirstLast;
    @NotNull
    public static final String dialectName = "postgresql";

    public PostgreSQLDialect() {
        super(dialectName, PostgreSQLDataTypeProvider.INSTANCE, PostgreSQLFunctionProvider.INSTANCE);
        this.supportsOrderByNullsFirstLast = true;
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return this.supportsOrderByNullsFirstLast;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return true;
    }

    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(column, "column");
        Intrinsics.checkNotNullParameter(columnDiff, "columnDiff");
        StringBuilder $this$modifyColumn_u24lambda_u2d2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Transaction tr = TransactionManager.Companion.current();
        $this$modifyColumn_u24lambda_u2d2.append("ALTER TABLE " + tr.identity(column.getTable()) + ' ');
        String colName = tr.identity(column);
        $this$modifyColumn_u24lambda_u2d2.append("ALTER COLUMN " + colName + " TYPE " + column.getColumnType().sqlType());
        if (columnDiff.getNullability()) {
            $this$modifyColumn_u24lambda_u2d2.append(", ALTER COLUMN " + colName + ' ');
            if (column.getColumnType().getNullable()) {
                $this$modifyColumn_u24lambda_u2d2.append("DROP ");
            } else {
                $this$modifyColumn_u24lambda_u2d2.append("SET ");
            }
            $this$modifyColumn_u24lambda_u2d2.append("NOT NULL");
        }
        if (columnDiff.getDefaults()) {
            StringBuilder stringBuilder2;
            Expression<?> expression = column.getDbDefaultValue$exposed_core();
            if (expression == null) {
                stringBuilder2 = null;
            } else {
                Expression<?> it = expression;
                boolean bl2 = false;
                stringBuilder2 = $this$modifyColumn_u24lambda_u2d2.append(", ALTER COLUMN " + colName + " SET DEFAULT " + PostgreSQLDataTypeProvider.INSTANCE.processForDefaultValue(it));
            }
            StringBuilder stringBuilder3 = stringBuilder2;
            if (stringBuilder3 == null) {
                StringBuilder $this$modifyColumn_u24lambda_u2d2_u24lambda_u2d1 = $this$modifyColumn_u24lambda_u2d2;
                boolean bl3 = false;
                String cfr_ignored_0 = ",  ALTER COLUMN " + colName + " DROP DEFAULT";
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return CollectionsKt.listOf(string);
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return Intrinsics.stringPlus("CREATE DATABASE ", DefaultKt.inProperCase(name));
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return Intrinsics.stringPlus("DROP DATABASE ", DefaultKt.inProperCase(name));
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        return Intrinsics.stringPlus("SET search_path TO ", schema.getIdentifier());
    }

    @Override
    @NotNull
    protected String createIndexWithType(@NotNull String name, @NotNull String table, @NotNull String columns2, @NotNull String type2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(columns2, "columns");
        Intrinsics.checkNotNullParameter(type2, "type");
        return "CREATE INDEX " + name + " ON " + table + " USING " + type2 + ' ' + columns2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/vendors/PostgreSQLDialect$Companion;", "", "()V", "dialectName", "", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

