/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.fastutil.doubles;

import com.sk89q.worldedit.bukkit.fastutil.doubles.DoubleCollection;
import com.sk89q.worldedit.bukkit.fastutil.doubles.DoubleConsumer;
import com.sk89q.worldedit.bukkit.fastutil.doubles.DoubleIterator;
import com.sk89q.worldedit.bukkit.fastutil.doubles.DoubleIterators;
import com.sk89q.worldedit.bukkit.fastutil.doubles.DoublePredicate;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;

public abstract class AbstractDoubleCollection
extends AbstractCollection<Double>
implements DoubleCollection {
    protected AbstractDoubleCollection() {
    }

    @Override
    public abstract DoubleIterator iterator();

    @Override
    public boolean add(double k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(double k) {
        DoubleIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (k != iterator.nextDouble()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(double k) {
        DoubleIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (k != iterator.nextDouble()) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean add(Double key) {
        return DoubleCollection.super.add(key);
    }

    @Override
    @Deprecated
    public boolean contains(Object key) {
        return DoubleCollection.super.contains(key);
    }

    @Override
    @Deprecated
    public boolean remove(Object key) {
        return DoubleCollection.super.remove(key);
    }

    @Override
    public double[] toArray(double[] a2) {
        int size = this.size();
        if (a2 == null) {
            a2 = new double[size];
        } else if (a2.length < size) {
            a2 = Arrays.copyOf(a2, size);
        }
        DoubleIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public double[] toDoubleArray() {
        return this.toArray((double[])null);
    }

    @Override
    @Deprecated
    public double[] toDoubleArray(double[] a2) {
        return this.toArray(a2);
    }

    @Override
    public final void forEach(DoubleConsumer action) {
        DoubleCollection.super.forEach(action);
    }

    @Override
    public final boolean removeIf(DoublePredicate filter) {
        return DoubleCollection.super.removeIf(filter);
    }

    @Override
    public boolean addAll(DoubleCollection c2) {
        boolean retVal = false;
        DoubleIterator i = c2.iterator();
        while (i.hasNext()) {
            if (!this.add(i.nextDouble())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Double> c2) {
        if (c2 instanceof DoubleCollection) {
            return this.addAll((DoubleCollection)c2);
        }
        return super.addAll(c2);
    }

    @Override
    public boolean containsAll(DoubleCollection c2) {
        DoubleIterator i = c2.iterator();
        while (i.hasNext()) {
            if (this.contains(i.nextDouble())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        if (c2 instanceof DoubleCollection) {
            return this.containsAll((DoubleCollection)c2);
        }
        return super.containsAll(c2);
    }

    @Override
    public boolean removeAll(DoubleCollection c2) {
        boolean retVal = false;
        DoubleIterator i = c2.iterator();
        while (i.hasNext()) {
            if (!this.rem(i.nextDouble())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        if (c2 instanceof DoubleCollection) {
            return this.removeAll((DoubleCollection)c2);
        }
        return super.removeAll(c2);
    }

    @Override
    public boolean retainAll(DoubleCollection c2) {
        boolean retVal = false;
        DoubleIterator i = this.iterator();
        while (i.hasNext()) {
            if (c2.contains(i.nextDouble())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        if (c2 instanceof DoubleCollection) {
            return this.retainAll((DoubleCollection)c2);
        }
        return super.retainAll(c2);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        DoubleIterator i = this.iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            double k = i.nextDouble();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

