/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.fastutil.doubles;

import com.sk89q.worldedit.bukkit.fastutil.doubles.DoubleComparator;
import java.io.Serializable;
import java.util.Comparator;

public final class DoubleComparators {
    public static final DoubleComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final DoubleComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    private DoubleComparators() {
    }

    public static DoubleComparator oppositeComparator(DoubleComparator c2) {
        if (c2 instanceof OppositeComparator) {
            return ((OppositeComparator)c2).comparator;
        }
        return new OppositeComparator(c2);
    }

    public static DoubleComparator asDoubleComparator(final Comparator<? super Double> c2) {
        if (c2 == null || c2 instanceof DoubleComparator) {
            return (DoubleComparator)c2;
        }
        return new DoubleComparator(){

            @Override
            public int compare(double x, double y) {
                return c2.compare(x, y);
            }

            @Override
            public int compare(Double x, Double y) {
                return c2.compare(x, y);
            }
        };
    }

    protected static class OppositeComparator
    implements DoubleComparator,
    Serializable {
        private static final long serialVersionUID = 1L;
        final DoubleComparator comparator;

        protected OppositeComparator(DoubleComparator c2) {
            this.comparator = c2;
        }

        @Override
        public final int compare(double a2, double b) {
            return this.comparator.compare(b, a2);
        }

        @Override
        public final DoubleComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements DoubleComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(double a2, double b) {
            return Double.compare(a2, b);
        }

        @Override
        public DoubleComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }

        private Object readResolve() {
            return NATURAL_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements DoubleComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(double a2, double b) {
            return -Double.compare(a2, b);
        }

        @Override
        public DoubleComparator reversed() {
            return NATURAL_COMPARATOR;
        }

        private Object readResolve() {
            return OPPOSITE_COMPARATOR;
        }
    }
}

