/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Locale;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Modules.CustomText.CTextManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Locale.YmlMaker;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class Language {
    private CMI plugin;
    private HashMap<String, FileConfiguration> locales = new HashMap();
    static Pattern patern = Pattern.compile("(\\\\n)");

    public Language(CMI cMI) {
        this.plugin = cMI;
    }

    public void reload() {
        try {
            this.locales.put(this.plugin.getConfigManager().Lang.toLowerCase(), new YmlMaker((JavaPlugin)this.plugin, "Translations" + File.separator + "Locale_" + this.plugin.getConfigManager().Lang + ".yml").getConfig());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private FileConfiguration getEN() {
        if (this.locales.get("en") == null) {
            try {
                this.locales.put("en", new YmlMaker((JavaPlugin)this.plugin, "Translations" + File.separator + "Locale_EN.yml").getConfig());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.locales.get("en");
    }

    public FileConfiguration getCustom() {
        if (this.locales.get(this.plugin.getConfigManager().Lang.toLowerCase()) == null) {
            try {
                this.locales.put(this.plugin.getConfigManager().Lang.toLowerCase(), new YmlMaker((JavaPlugin)this.plugin, "Translations" + File.separator + "Locale_" + this.plugin.getConfigManager().Lang + ".yml").getConfig());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.locales.get(this.plugin.getConfigManager().Lang.toLowerCase());
    }

    private FileConfiguration getLocale(String string) {
        if (string.length() > 10) {
            return this.getEN();
        }
        if (this.locales.get(string) == null) {
            try {
                File file = new File(this.plugin.getDataFolder(), "Translations" + File.separator + "Locale_" + string.toUpperCase() + ".yml");
                if (!file.isFile()) {
                    return this.getEN();
                }
                this.locales.put(string.toUpperCase(), new YmlMaker((JavaPlugin)this.plugin, "Translations" + File.separator + "Locale_" + string.toUpperCase() + ".yml").getConfig());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.locales.getOrDefault(string, this.getEN());
    }

    @Deprecated
    public String getMessage(String string, Object ... objectArray) {
        return this.getLMessage(this.plugin.getConfigManager().Lang, string, objectArray);
    }

    public String getLMessage(String string, String string2, Object ... objectArray) {
        Object object;
        Object object2;
        Location location;
        Object object3;
        string = string == null ? this.plugin.getConfigManager().Lang.toLowerCase() : string.toLowerCase();
        String string3 = "Missing locale for " + string2 + " ";
        String string4 = "";
        FileConfiguration fileConfiguration = this.getLocale(string);
        if (fileConfiguration.isString(string2)) {
            string4 = String.valueOf(string4) + fileConfiguration.getString(string2);
        } else if (fileConfiguration.isList(string2)) {
            object3 = fileConfiguration.getStringList(string2);
            location = object3.iterator();
            while (location.hasNext()) {
                object2 = (String)location.next();
                if (!string4.isEmpty()) {
                    string4 = String.valueOf(string4) + "\n";
                }
                string4 = String.valueOf(string4) + (String)object2;
            }
        } else {
            string4 = String.valueOf(string4) + (this.getEN().isString(string2) ? this.getEN().getString(string2) : string3);
        }
        object3 = null;
        object2 = null;
        location = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = objectArray2[n2];
            if (object instanceof Snd && object3 == null) {
                object3 = (Snd)object;
                arrayList.add(object);
            } else if (object instanceof CMIUser && object2 == null) {
                object2 = (CMIUser)object;
                object3 = new Snd().setSender((CMIUser)object2).setTarget((CMIUser)object2);
                arrayList.add(object);
            } else if (object instanceof Location && location == null) {
                location = (Location)object;
                arrayList.add(object);
            } else if (object instanceof Player && object3 == null) {
                object3 = new Snd().setTarget((Player)object).setTarget((Player)object);
            }
            ++n2;
        }
        if (location != null) {
            string4 = this.replacePlayer(location, string4);
        }
        if (object2 != null && ((CMIUser)object2).getPlayer(false) != null && (object = ((CMIUser)object2).getPlayer(false)) != null) {
            string4 = this.replacePlayer("", (Player)object, null, string4);
            if (object.getLocation() != null) {
                string4 = this.replacePlayer(object.getLocation(), string4);
            }
        }
        if (objectArray.length > 0) {
            int n3 = 0;
            while (n3 < objectArray.length) {
                if (!arrayList.contains(objectArray[n3])) {
                    if (objectArray.length >= n3 + 2) {
                        Object object4 = objectArray[n3 + 1];
                        if (object4 instanceof Boolean) {
                            Object object5 = object4 = (Boolean)object4 != false ? LC.info_variables_Enabled.getLocale(new Object[0]) : LC.info_variables_Disabled.getLocale(new Object[0]);
                        }
                        if (object4 instanceof LC) {
                            object4 = ((LC)object4).getText();
                        }
                        string4 = Language.outReplace(string4, objectArray[n3], object4);
                    }
                    ++n3;
                }
                ++n3;
            }
        }
        if (object3 != null) {
            string4 = this.updateSnd((Snd)object3, string4);
        }
        string4 = string4.replace("!prefix!", LC.info_prefix.getLocale(new Object[0]));
        string4 = this.filterNewLine(string4);
        return CMIChatColor.translate((String)string4);
    }

    public String filterNewLine(String string) {
        Matcher matcher = patern.matcher(string);
        while (matcher.find()) {
            if (matcher.group(1) == null || matcher.group(1).isEmpty()) continue;
            string = string.replace(matcher.group(1), "\n");
        }
        return string;
    }

    public List<String> updateSnd(Snd snd, List<String> list2) {
        int n = 0;
        int n2 = list2.size();
        while (n < n2) {
            list2.set(n, this.updateSnd(snd, list2.get(n)));
            ++n;
        }
        return list2;
    }

    public String updateSnd(Snd snd, String string) {
        String string2;
        if (string == null) {
            return null;
        }
        if (!string.contains("[")) {
            string = this.filterNewLine(string);
            return string;
        }
        string = Language.replace(string, "serverName", this.plugin.getBungeeCordManager().isBungeeCord() ? this.plugin.getBungeeCordManager().getThisServerName() : CMILib.getInstance().getReflectionManager().getServerName());
        if (snd.getConsoleSender() != null) {
            string2 = snd.getConsoleSender().getName();
            if (string2.equalsIgnoreCase("Console") || string2.equalsIgnoreCase(this.plugin.getPlayerManager().getFakeUserName())) {
                string2 = LC.info_Console.getLocale(new Object[0]);
            }
            string = Language.replace(string, "senderName", string2);
            string = Language.replace(string, "senderDisplayName", string2);
            string = Language.replace(string, "senderPrefix", "");
            string = Language.replace(string, "senderSuffix", "");
        }
        if (snd.getPlayerSender() != null) {
            string = this.replacePlayer("sender", snd.getPlayerSender(), snd.getPlayerTarget(), string);
            if (snd.getPlayerSender().getLocation() != null) {
                string = this.replacePlayer(snd.getPlayerSender().getLocation(), string);
            }
        }
        if (snd.getSenderUser() != null) {
            string = this.replaceUser("sender", snd.getSenderUser(), string);
        }
        if (snd.getConsoleTarget() != null) {
            string2 = snd.getConsoleTarget().getName();
            if (string2.equalsIgnoreCase("Console") || string2.equalsIgnoreCase(this.plugin.getPlayerManager().getFakeUserName())) {
                string2 = LC.info_Console.getLocale(new Object[0]);
            }
            string = Language.replace(string, "targetName", string2);
            string = Language.replace(string, "targetDisplayName", string2);
        }
        if (snd.getPlayerTarget() != null) {
            string = this.replacePlayer("", snd.getPlayerTarget(), snd.getPlayerSender(), string);
            if (snd.getPlayerTarget().getLocation() != null) {
                string = this.replacePlayer(snd.getPlayerTarget().getLocation(), string);
            }
        }
        if (snd.getTargetUser() != null) {
            string = this.replaceUser("", snd.getTargetUser(), snd.getPlayerSender(), string);
        }
        if (snd.getConsoleSource() != null) {
            string2 = snd.getConsoleSource().getName();
            if (string2.equalsIgnoreCase("Console") || string2.equalsIgnoreCase(this.plugin.getPlayerManager().getFakeUserName())) {
                string2 = LC.info_Console.getLocale(new Object[0]);
            }
            string = Language.replace(string, "sourceName", string2);
            string = Language.replace(string, "sourceDisplayName", string2);
        }
        if (snd.getSenderName() != null) {
            string2 = snd.getSenderName();
            if (string2.equalsIgnoreCase("Console") || string2.equalsIgnoreCase(this.plugin.getPlayerManager().getFakeUserName())) {
                string2 = LC.info_Console.getLocale(new Object[0]);
            }
            string = Language.replace(string, "senderName", string2);
            string = Language.replace(string, "senderDisplayName", string2);
            string = Language.replace(string, "senderPrefix", "");
            string = Language.replace(string, "senderSuffix", "");
        }
        if (snd.getTargetName() != null) {
            string2 = snd.getTargetName();
            if (string2.equalsIgnoreCase("Console") || string2.equalsIgnoreCase(this.plugin.getPlayerManager().getFakeUserName())) {
                string2 = LC.info_Console.getLocale(new Object[0]);
            }
            string = Language.replace(string, "Name", string2);
            string = Language.replace(string, "DisplayName", string2);
            string = Language.replace(string, "playerName", string2);
            string = Language.replace(string, "playerDisplayName", string2);
        }
        if (snd.getPlayerSource() != null) {
            string = this.replacePlayer("source", snd.getPlayerSource(), snd.getPlayerTarget(), string);
            if (snd.getPlayerSource().getLocation() != null) {
                string = this.replacePlayer(snd.getPlayerSource().getLocation(), string);
            }
        }
        if (snd.getSourceUser() != null) {
            string = this.replaceUser("source", snd.getSourceUser(), snd.getPlayerSender(), string);
        }
        string = this.filterNewLine(string);
        return string;
    }

    public String replacePlayer(String string, Player player, Player player2, String string2) {
        if ((string2 = Language.replace(string2, "serverName", this.plugin.getBungeeCordManager().isBungeeCord() ? this.plugin.getBungeeCordManager().getThisServerName() : CMILib.getInstance().getReflectionManager().getServerName())) == null || player == null) {
            return string2;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        string2 = Language.replace(string2, String.valueOf(string) + "offon", this.plugin.getOffOn(player, player2));
        if (cMIUser != null) {
            string2 = Language.replace(string2, String.valueOf(string) + "Lvl", cMIUser.getLevel());
        }
        string2 = Language.replace(string2, String.valueOf(string) + "Hp", (int)player.getHealth());
        string2 = Language.replace(string2, String.valueOf(string) + "MaxHp", (int)player.getMaxHealth());
        if (cMIUser != null) {
            string2 = Language.replace(string2, String.valueOf(string) + "Exp", cMIUser.getExp());
        }
        string2 = Language.replace(string2, String.valueOf(string) + "Hunger", player.getFoodLevel());
        if (player.getGameMode() != null) {
            string2 = Language.replace(string2, String.valueOf(string) + "GameMode", CMILib.getInstance().getLM().getMessage("info.variables." + player.getGameMode().name().toLowerCase(), new Object[0]));
        }
        if (cMIUser != null) {
            if (cMIUser.getName().equalsIgnoreCase(this.plugin.getPlayerManager().getFakeUserName())) {
                string2 = Language.replace(string2, String.valueOf(string) + "Name", LC.info_Console.getLocale(new Object[0]));
                string2 = Language.replace(string2, String.valueOf(string) + "Nick", LC.info_Console.getLocale(new Object[0]));
                string2 = Language.replace(string2, String.valueOf(string) + "NickName", LC.info_Console.getLocale(new Object[0]));
                string2 = Language.replace(string2, String.valueOf(string) + "DisplayName", LC.info_Console.getLocale(new Object[0]));
            } else {
                string2 = Language.replace(string2, String.valueOf(string) + "Name", cMIUser.getName());
                string2 = Language.replace(string2, String.valueOf(string) + "Nick", cMIUser.getNickName());
                string2 = Language.replace(string2, String.valueOf(string) + "NickName", cMIUser.getDisplayName(true));
                string2 = Language.replace(string2, String.valueOf(string) + "DisplayName", cMIUser.getDisplayName(true));
            }
            string2 = Language.replace(string2, String.valueOf(string) + "Prefix", CMIChatColor.translate((String)cMIUser.getPrefix()));
            string2 = Language.replace(string2, String.valueOf(string) + "Suffix", CMIChatColor.translate((String)cMIUser.getSuffix()));
            if (string.isEmpty()) {
                if (cMIUser.getName().equalsIgnoreCase(this.plugin.getPlayerManager().getFakeUserName())) {
                    string2 = Language.replace(string2, "playerName", LC.info_Console.getLocale(new Object[0]));
                    string2 = Language.replace(string2, "playerNick", LC.info_Console.getLocale(new Object[0]));
                    string2 = Language.replace(string2, "playerNickName", LC.info_Console.getLocale(new Object[0]));
                    string2 = Language.replace(string2, "playerDisplayName", LC.info_Console.getLocale(new Object[0]));
                    string2 = Language.replace(string2, "Prefix", "");
                    string2 = Language.replace(string2, "Suffix", "");
                } else {
                    string2 = Language.replace(string2, "playerName", cMIUser.getName());
                    string2 = Language.replace(string2, "playerNick", cMIUser.getNickName());
                    string2 = Language.replace(string2, "playerNickName", cMIUser.getDisplayName(true));
                    string2 = Language.replace(string2, "playerDisplayName", cMIUser.getDisplayName(true));
                    string2 = Language.replace(string2, "Prefix", CMIChatColor.translate((String)cMIUser.getPrefix()));
                    string2 = Language.replace(string2, "Suffix", CMIChatColor.translate((String)cMIUser.getSuffix()));
                }
            }
        }
        if (player.getLocation() != null) {
            string2 = this.replacePlayer(string, player.getLocation(), string2);
        }
        return string2;
    }

    public String replaceUser(String string, CMIUser cMIUser, String string2) {
        return this.replaceUser(string, cMIUser, null, string2);
    }

    public String replaceUser(String string, CMIUser cMIUser, Player player, String string2) {
        if ((string2 = Language.replace(string2, "serverName", this.plugin.getBungeeCordManager().isBungeeCord() ? this.plugin.getBungeeCordManager().getThisServerName() : CMILib.getInstance().getReflectionManager().getServerName())) == null || cMIUser == null) {
            return string2;
        }
        if (cMIUser.isOnline()) {
            return this.replacePlayer(string, cMIUser.getPlayer(false), player, string2);
        }
        string2 = Language.replace(string2, String.valueOf(string) + "offon", this.plugin.getOffOn(cMIUser.getPlayer(false), player));
        string2 = Language.replace(string2, String.valueOf(string) + "Name", cMIUser.getName(false));
        string2 = Language.replace(string2, String.valueOf(string) + "Nick", cMIUser.getNickName());
        string2 = Language.replace(string2, String.valueOf(string) + "NickName", cMIUser.getNickName());
        string2 = Language.replace(string2, String.valueOf(string) + "DisplayName", cMIUser.getDisplayName(true));
        string2 = Language.replace(string2, String.valueOf(string) + "Prefix", CMIChatColor.translate((String)cMIUser.getPrefix()));
        string2 = Language.replace(string2, String.valueOf(string) + "Suffix", CMIChatColor.translate((String)cMIUser.getSuffix()));
        if (string.isEmpty()) {
            string2 = Language.replace(string2, "playerName", cMIUser.getName(false));
            string2 = Language.replace(string2, "playerNick", cMIUser.getNickName());
            string2 = Language.replace(string2, "playerNickName", cMIUser.getNickName());
            string2 = Language.replace(string2, "playerDisplayName", cMIUser.getDisplayName(true));
            string2 = Language.replace(string2, "Prefix", CMIChatColor.translate((String)cMIUser.getPrefix()));
            string2 = Language.replace(string2, "Suffix", CMIChatColor.translate((String)cMIUser.getSuffix()));
        }
        if (cMIUser.getLogOutLocation() != null) {
            string2 = this.replacePlayer(string, cMIUser.getLogOutLocation(), string2);
        }
        return string2;
    }

    public String replacePlayer(String string, Location location, String string2) {
        if (string2 == null || location == null) {
            return string2;
        }
        string2 = Language.replace(string2, String.valueOf(string) + "X", location.getBlockX());
        string2 = Language.replace(string2, String.valueOf(string) + "Y", location.getBlockY());
        string2 = Language.replace(string2, String.valueOf(string) + "Z", location.getBlockZ());
        string2 = Language.replace(string2, String.valueOf(string) + "Yaw", (int)location.getYaw());
        string2 = Language.replace(string2, String.valueOf(string) + "Pitch", (int)location.getPitch());
        if (location.getWorld() != null) {
            string2 = Language.replace(string2, String.valueOf(string) + "WorldName", location.getWorld().getName());
            string2 = Language.replace(string2, String.valueOf(string) + "World", location.getWorld().getName());
        }
        return string2;
    }

    public String replacePlayer(Location location, String string) {
        if (string == null || location == null) {
            return string;
        }
        string = Language.replace(string, "x", location.getBlockX());
        string = Language.replace(string, "y", location.getBlockY());
        string = Language.replace(string, "z", location.getBlockZ());
        string = Language.replace(string, "yaw", (int)location.getYaw());
        string = Language.replace(string, "pitch", (int)location.getPitch());
        if (location.getWorld() != null) {
            string = Language.replace(string, "worldName", location.getWorld().getName());
            string = Language.replace(string, "world", location.getWorld().getName());
        }
        return string;
    }

    private static String outReplace(String string, Object object, Object object2) {
        if (object == null) {
            return string;
        }
        if (object2 == null) {
            object2 = "";
        }
        object2 = CTextManager.clean(String.valueOf(object2));
        return string.replace(String.valueOf(object), String.valueOf(object2));
    }

    private static String replace(String string, Object object, Object object2) {
        if (object == null) {
            return string;
        }
        if (object2 == null) {
            object2 = "";
        }
        object2 = CTextManager.clean(String.valueOf(object2));
        return string.replaceAll(String.valueOf("(?i)(\\[" + object + "\\])"), Matcher.quoteReplacement(String.valueOf(object2)));
    }

    public String getDefaultMessage(String string) {
        String string2 = "Missing locale for " + string + " ";
        String string3 = "";
        string3 = this.getEN().isString(string) ? this.getEN().getString(string) : string2;
        StringBuilder stringBuilder = new StringBuilder();
        if (string3.contains("/n")) {
            int n = 0;
            String[] stringArray = string3.split("/n");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string4 = stringArray[n3];
                stringBuilder.append(string4);
                if (++n < string3.split("/n").length) {
                    stringBuilder.append("\n  ");
                }
                ++n3;
            }
            string3 = stringBuilder.toString();
        }
        return CMIChatColor.translate((String)string3);
    }

    @Deprecated
    public List<String> getMessageList(String string, Object ... objectArray) {
        return this.getMessageLList(this.plugin.getConfigManager().Lang, string, objectArray);
    }

    public List<String> getMessageLList(String string, String string2, Object ... objectArray) {
        int n;
        List list2;
        string = string == null ? this.plugin.getConfigManager().Lang.toLowerCase() : string.toLowerCase();
        String string3 = "Missing locale for " + string2 + " ";
        FileConfiguration fileConfiguration = this.getLocale(string);
        if (fileConfiguration.isList(string2)) {
            list2 = fileConfiguration.getStringList(string2);
        } else {
            List list3 = list2 = !this.getEN().getStringList(string2).isEmpty() ? this.getEN().getStringList(string2) : Arrays.asList(string3);
        }
        if (objectArray != null && objectArray.length > 0) {
            n = 0;
            while (n < list2.size()) {
                String string4 = (String)list2.get(n);
                int n2 = 0;
                while (n2 < objectArray.length) {
                    string4 = string4.replace(String.valueOf(objectArray[n2]), String.valueOf(objectArray[n2 + 1]));
                    n2 += 2;
                }
                string4 = this.filterNewLine(string4);
                list2.set(n, CMIChatColor.translate((String)string4));
                ++n;
            }
        }
        n = 0;
        for (String string4 : list2) {
            list2.set(n, CMIChatColor.translate((String)string4.replace("!prefix!", LC.info_prefix.getLocale(new Object[0]))));
            ++n;
        }
        return list2;
    }

    @Deprecated
    public boolean isList(String string) {
        return this.isLList(this.plugin.getConfigManager().Lang, string);
    }

    public boolean isLList(String string, String string2) {
        FileConfiguration fileConfiguration = this.getLocale(string = string == null ? this.plugin.getConfigManager().Lang.toLowerCase() : string.toLowerCase());
        if (fileConfiguration != null && fileConfiguration.contains(string2)) {
            return fileConfiguration.isList(string2);
        }
        if (this.getEN().contains(string2)) {
            return this.getEN().isList(string2);
        }
        return false;
    }

    @Deprecated
    public boolean containsKey(String string) {
        return this.containsLKey(this.plugin.getConfigManager().Lang, string);
    }

    public boolean containsLKey(String string, String string2) {
        FileConfiguration fileConfiguration = this.getLocale(string = string == null ? this.plugin.getConfigManager().Lang.toLowerCase() : string.toLowerCase());
        if (fileConfiguration != null && fileConfiguration.contains(string2)) {
            return true;
        }
        return this.getEN().contains(string2);
    }

    public boolean isString(String string) {
        return this.getEN().isString(string);
    }

    @Deprecated
    public Set<String> getKeys(String string) {
        return this.getLKeys(this.plugin.getConfigManager().Lang, string);
    }

    public Set<String> getLKeys(String string, String string2) {
        FileConfiguration fileConfiguration = this.getLocale(string = string == null ? this.plugin.getConfigManager().Lang.toLowerCase() : string.toLowerCase());
        if (fileConfiguration.isConfigurationSection(string2)) {
            return fileConfiguration.getConfigurationSection(string2).getKeys(false);
        }
        if (this.getEN() != null && this.getEN().isConfigurationSection(string2)) {
            return this.getEN().getConfigurationSection(string2).getKeys(false);
        }
        return new HashSet<String>();
    }
}

