/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.ArmorEffects;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.ArmorEffects.ArmorEffectManager;
import com.Zrips.CMI.events.CMIArmorChangeEvent;
import com.Zrips.CMI.utils.CMIEncoder;
import java.util.List;
import net.Zrips.CMILib.NBT.CMINBT;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ArmorEffectListener
implements Listener {
    private CMI plugin;

    public ArmorEffectListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockInteract(CMIArmorChangeEvent cMIArmorChangeEvent) {
        if (cMIArmorChangeEvent.isCancelled()) {
            return;
        }
        Player player = cMIArmorChangeEvent.getPlayer();
        this.modifyOldEffect(player, cMIArmorChangeEvent.getOldArmorPiece());
        this.applyNewEffect(player, cMIArmorChangeEvent.getNewArmorPiece());
    }

    private void modifyOldEffect(Player player, ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        CMINBT cMINBT = new CMINBT(itemStack);
        if (!cMINBT.hasNBT("CMIArmorEffects")) {
            return;
        }
        List<String> list2 = cMINBT.getList("CMIArmorEffects");
        if (list2 == null) {
            return;
        }
        if ((list2 = CMIEncoder.decodeList(list2)) == null) {
            return;
        }
        for (String string : list2) {
            PotionEffect potionEffect;
            PotionEffect potionEffect2 = this.plugin.getUtilManager().deserializePotionEffect(string);
            if (potionEffect2 == null || potionEffect2.getType().equals(PotionEffectType.NIGHT_VISION) && (potionEffect2 = this.plugin.getUtilManager().deserializePotionEffect(string, 30)) == null || (potionEffect = ArmorEffectManager.getPotionEffect(player, potionEffect2.getType())) == null) continue;
            if (potionEffect.getDuration() <= potionEffect2.getDuration() * 2) {
                player.removePotionEffect(potionEffect2.getType());
                continue;
            }
            PotionEffect potionEffect3 = new PotionEffect(potionEffect.getType(), potionEffect.getDuration() - potionEffect2.getDuration(), potionEffect2.getAmplifier(), true, potionEffect2.hasParticles());
            player.removePotionEffect(potionEffect2.getType());
            player.addPotionEffect(potionEffect3);
        }
    }

    private void applyNewEffect(Player player, ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        CMINBT cMINBT = new CMINBT(itemStack);
        if (!cMINBT.hasNBT("CMIArmorEffects")) {
            return;
        }
        List<String> list2 = cMINBT.getList("CMIArmorEffects");
        if (list2 == null) {
            return;
        }
        if ((list2 = CMIEncoder.decodeList(list2)) == null) {
            return;
        }
        for (String string : list2) {
            PotionEffect potionEffect = this.plugin.getUtilManager().deserializePotionEffect(string);
            if (potionEffect == null || potionEffect.getType().equals(PotionEffectType.NIGHT_VISION) && (potionEffect = this.plugin.getUtilManager().deserializePotionEffect(string, 30)) == null) continue;
            player.addPotionEffect(potionEffect);
        }
        this.plugin.getArmorEffectManager().addPlayer(player.getUniqueId());
        this.plugin.getArmorEffectManager().tasker();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLoginNameCheck(PlayerJoinEvent playerJoinEvent) {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            if (playerJoinEvent.getPlayer().isOnline() && this.plugin.getArmorEffectManager().checkPlayerArmor(playerJoinEvent.getPlayer())) {
                this.plugin.getArmorEffectManager().addPlayer(playerJoinEvent.getPlayer().getUniqueId());
            }
        }, 20L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
        this.plugin.getArmorEffectManager().removePlayer(playerQuitEvent.getPlayer().getUniqueId());
    }
}

