/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.BungeeCord;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.BungeeCord.BungeePlayer;
import com.Zrips.CMI.Modules.BungeeCord.ServerListPing;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.Zrips.CMILib.Colors.CMIChatColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BungeeCordServer {
    private String name;
    private String ip;
    private Integer port;
    private String motd = "";
    private int maxPlayers = 0;
    private int currentPlayers = 0;
    private Long nextCheck = 0L;
    private boolean online = false;
    private ConcurrentHashMap<String, BungeePlayer> playersMapUUID = new ConcurrentHashMap();
    private ConcurrentHashMap<String, BungeePlayer> playersMapName = new ConcurrentHashMap();

    public BungeeCordServer(String string, String string2, Integer n) {
        this.name = string;
        this.ip = string2;
        this.port = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String string) {
        this.ip = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getMotd() {
        return this.motd;
    }

    public void setMotd(String string) {
        this.motd = string;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public void setMaxPlayers(int n) {
        this.maxPlayers = n;
    }

    public int getCurrentPlayers() {
        int n = 0;
        Iterator<Map.Entry<String, BungeePlayer>> iterator = this.playersMapName.entrySet().iterator();
        while (iterator.hasNext()) {
            BungeePlayer bungeePlayer = iterator.next().getValue();
            if (bungeePlayer.getVanished()) continue;
            ++n;
        }
        return n;
    }

    public Long getNextCheck() {
        return this.nextCheck;
    }

    public void setNextCheck(Long l) {
        this.nextCheck = l;
    }

    public void update() {
        if (this.nextCheck > System.currentTimeMillis()) {
            return;
        }
        if (this.getName().equalsIgnoreCase(CMI.getInstance().getBungeeCordManager().getThisServerName())) {
            this.maxPlayers = Bukkit.getMaxPlayers();
            HashMap<String, BungeePlayer> hashMap = new HashMap<String, BungeePlayer>(this.playersMapUUID);
            this.playersMapUUID.clear();
            this.playersMapName.clear();
            for (Player player : Bukkit.getOnlinePlayers()) {
                BungeePlayer bungeePlayer = hashMap.get(player.getUniqueId().toString());
                if (bungeePlayer == null) {
                    bungeePlayer = new BungeePlayer();
                    bungeePlayer.setBungeeServer(this);
                    bungeePlayer.setName(player.getName());
                    bungeePlayer.setUniqueId(player.getUniqueId());
                }
                CMIUser cMIUser = CMI.getInstance().getPlayerManager().getUser(player);
                bungeePlayer.setNickName(cMIUser.getNickName());
                bungeePlayer.setPlayerDisplayName(cMIUser.getDisplayName());
                bungeePlayer.setVanished(cMIUser.isVanished());
                this.playersMapUUID.put(player.getUniqueId().toString(), bungeePlayer);
                this.playersMapName.put(player.getName().toLowerCase(), bungeePlayer);
            }
            this.currentPlayers = CMI.getInstance().getUtilManager().getOnlinePlayerCount();
            this.motd = CMIChatColor.deColorize((String)Bukkit.getMotd());
            this.online = true;
            this.nextCheck = System.currentTimeMillis() + 1000L;
            return;
        }
        BungeeCordServer bungeeCordServer = this;
        if (this.ip == null || this.port == null || this.nextCheck > System.currentTimeMillis()) {
            return;
        }
        this.nextCheck = System.currentTimeMillis() + 1000L;
        CMI.getInstance().getBungeeCordManager().getBungeeCord().getPlayerList(this.getName()).whenComplete((list2, throwable) -> {
            HashMap<String, BungeePlayer> hashMap = new HashMap<String, BungeePlayer>(this.playersMapName);
            this.playersMapUUID.clear();
            this.playersMapName.clear();
            bungeeCordServer.setOnline(true);
            if (list2.size() > 1 || !((String)list2.get(0)).isEmpty()) {
                this.currentPlayers = list2.size();
            }
            list2.stream().forEach(string -> {
                if (string.isEmpty()) {
                    return;
                }
                BungeePlayer bungeePlayer = (BungeePlayer)hashMap.get(string.toLowerCase());
                if (bungeePlayer == null) {
                    bungeePlayer = new BungeePlayer();
                }
                bungeePlayer.setBungeeServer(bungeeCordServer);
                bungeePlayer.setName((String)string);
                this.playersMapName.put(string.toLowerCase(), bungeePlayer);
                if (bungeePlayer.getUniqueId() != null) {
                    this.playersMapUUID.put(bungeePlayer.getUniqueId().toString(), bungeePlayer);
                    return;
                }
                CMI.getInstance().getBungeeCordManager().getBungeeCord().getUUID((String)string).whenComplete((string2, throwable) -> {
                    BungeePlayer bungeePlayer = this.playersMapName.get(string);
                    if (bungeePlayer == null) {
                        return;
                    }
                    bungeePlayer.setUniqueId(UUID.fromString(string2));
                    this.playersMapUUID.put((String)string2, bungeePlayer);
                });
            });
        });
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)CMI.getInstance(), new Runnable(){

            @Override
            public void run() {
                try {
                    ServerListPing serverListPing = new ServerListPing(BungeeCordServer.this.ip, BungeeCordServer.this.port);
                    ServerListPing.StatusResponse statusResponse = serverListPing.fetchData();
                    BungeeCordServer.this.maxPlayers = statusResponse.getPlayers().getMax();
                    if (BungeeCordServer.this.currentPlayers != BungeeCordServer.this.getCurrentPlayers()) {
                        CMI.getInstance().getBungeeCordManager().sendPlayerInfoRequest(BungeeCordServer.this.getName());
                    }
                    BungeeCordServer.this.currentPlayers = statusResponse.getPlayers().getOnline();
                    BungeeCordServer.this.online = true;
                }
                catch (Exception exception) {
                    BungeeCordServer.this.online = false;
                }
            }
        });
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean bl) {
        this.online = bl;
    }

    public ConcurrentHashMap<String, BungeePlayer> getPlayersMapUUID() {
        return this.playersMapUUID;
    }

    public BungeePlayer getPlayer(UUID uUID) {
        return this.playersMapUUID.get(uUID.toString());
    }

    public BungeePlayer getPlayer(String string) {
        BungeePlayer bungeePlayer = this.playersMapName.get(string.toLowerCase());
        if (bungeePlayer == null) {
            for (Map.Entry<String, BungeePlayer> entry : this.playersMapUUID.entrySet()) {
                if (entry.getValue().getNickName() == null || !entry.getValue().getNickName().equalsIgnoreCase(string)) continue;
                return entry.getValue();
            }
        }
        return bungeePlayer;
    }

    public void addPlayer(BungeePlayer bungeePlayer) {
        if (bungeePlayer.getUniqueId() != null) {
            this.playersMapUUID.put(bungeePlayer.getUniqueId().toString(), bungeePlayer);
        }
        if (bungeePlayer.getName() != null) {
            this.playersMapName.put(bungeePlayer.getName().toLowerCase(), bungeePlayer);
        }
    }

    public void removePlayer(UUID uUID, String string) {
        this.playersMapUUID.remove(uUID.toString());
        this.playersMapName.remove(string.toLowerCase());
    }

    public void clearPlayers() {
        if (this.playersMapUUID != null) {
            this.playersMapUUID.clear();
        }
        if (this.playersMapName != null) {
            this.playersMapName.clear();
        }
    }

    public ConcurrentHashMap<String, BungeePlayer> getPlayersMapName() {
        return this.playersMapName;
    }
}

