/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.EventActions;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.EventActions.EventActionManager;
import com.Zrips.CMI.Modules.Worlds.CMIWorld;
import com.Zrips.CMI.events.CMIPlayerBanEvent;
import com.Zrips.CMI.events.CMIPvPEndEventAsync;
import com.Zrips.CMI.events.CMIPvPStartEventAsync;
import java.util.HashMap;
import java.util.UUID;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class EventActionListener
implements Listener {
    private CMI plugin;
    HashMap<UUID, Long> last = new HashMap();

    public EventActionListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void PlayerPortalEvent(PlayerPortalEvent playerPortalEvent) {
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void CMIPvPEndEventAsync(final CMIPvPEndEventAsync cMIPvPEndEventAsync) {
        if (!EventActionManager.eventAction.pvpend.isEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                EventActionListener.this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.pvpend, cMIPvPEndEventAsync.getPlayer());
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void CMIPvPStartEventAsync(final CMIPvPStartEventAsync cMIPvPStartEventAsync) {
        if (!EventActionManager.eventAction.pvpstart.isEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                EventActionListener.this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.pvpstart, cMIPvPStartEventAsync.getPlayer());
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerFirstJoinEvent(final PlayerJoinEvent playerJoinEvent) {
        if (!EventActionManager.eventAction.firstJoinServer.isEnabled()) {
            return;
        }
        if (playerJoinEvent.getPlayer().hasPlayedBefore()) {
            return;
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                EventActionListener.this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.firstJoinServer, playerJoinEvent.getPlayer());
            }
        }, 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerJoinEvent(PlayerJoinEvent playerJoinEvent) {
        if (!EventActionManager.eventAction.joinServer.isEnabled()) {
            return;
        }
        if (!playerJoinEvent.getPlayer().hasPlayedBefore()) {
            return;
        }
        this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.joinServer, playerJoinEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerDeathEvent(PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity().getKiller();
        this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerDeath, playerDeathEvent.getEntity(), player);
        if (player != null) {
            this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerKillPlayer, playerDeathEvent.getEntity(), player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerRespawnEvent(PlayerRespawnEvent playerRespawnEvent) {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R1) && playerRespawnEvent.getRespawnReason().equals((Object)PlayerRespawnEvent.RespawnReason.END_PORTAL)) {
            return;
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerRespawn, playerRespawnEvent.getPlayer()), 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerQuitEvent(PlayerQuitEvent playerQuitEvent) {
        this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.quitServer, playerQuitEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerTeleportEvent(PlayerTeleportEvent playerTeleportEvent) {
        if (!playerTeleportEvent.getFrom().getWorld().equals(playerTeleportEvent.getTo().getWorld())) {
            this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerPreWorldChange, playerTeleportEvent.getPlayer());
        }
        this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerTeleport, playerTeleportEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerBedEnterEvent(PlayerBedEnterEvent playerBedEnterEvent) {
        this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.bedEnter, playerBedEnterEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerBedLeaveEvent(PlayerBedLeaveEvent playerBedLeaveEvent) {
        this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.bedLeave, playerBedLeaveEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerVoidFallEvent(PlayerMoveEvent playerMoveEvent) {
        if (playerMoveEvent.getTo().getY() < (double)(CMIWorld.getMinHeight(playerMoveEvent.getPlayer().getWorld()) - 10) && (this.last.get(playerMoveEvent.getPlayer().getUniqueId()) == null || this.last.get(playerMoveEvent.getPlayer().getUniqueId()) + 1000L < System.currentTimeMillis())) {
            this.last.put(playerMoveEvent.getPlayer().getUniqueId(), System.currentTimeMillis());
            this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.voidFall, playerMoveEvent.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerChangedWorldEvent(PlayerChangedWorldEvent playerChangedWorldEvent) {
        this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerWorldChange, playerChangedWorldEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerGameModeChangeEvent(final PlayerGameModeChangeEvent playerGameModeChangeEvent) {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                EventActionListener.this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerGameModeChange, playerGameModeChangeEvent.getPlayer());
            }
        }, 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerKickEvent(PlayerKickEvent playerKickEvent) {
        this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerKick, playerKickEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void CMIPlayerBanEvent(CMIPlayerBanEvent cMIPlayerBanEvent) {
        this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerBan, CMIUser.getOnlinePlayer(cMIPlayerBanEvent.getBanned()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerLevelChangeEvent(final PlayerLevelChangeEvent playerLevelChangeEvent) {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                EventActionListener.this.plugin.getEventActionManager().performCommands(EventActionManager.eventAction.playerLevelChange, playerLevelChangeEvent.getPlayer());
            }
        }, 1L);
    }
}

