/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.NickName;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import org.bukkit.entity.Player;

public class NickNameManager {
    private CMI plugin;
    private HashMap<String, UUID> NickMap = new HashMap();
    private HashMap<String, UUID> NameMap = new HashMap();
    private String NickNameFormat;
    private boolean DisplayNameChange;
    private String ValidNickNameRegex;
    private List<String> NickNameBlackList;
    private int NickNameLengthMax;
    private int NickNameLengthMin;
    private String NickNamePrefix;
    private Boolean PrefixWhenDifferent;
    private Boolean IncludeInTabComplete;
    private Boolean IncludeRealName;

    public NickNameManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void removeNickName(String string) {
        this.NickMap.remove(CMIChatColor.stripColor((String)string).toLowerCase());
    }

    public void addNewNickName(String string, UUID uUID) {
        this.NickMap.put(CMIChatColor.stripColor((String)string).toLowerCase(), uUID);
    }

    public void addNewName(String string, UUID uUID) {
        this.NameMap.put(string.toLowerCase(), uUID);
    }

    public UUID whoUsesName(String string) {
        UUID uUID = this.NickMap.get(string.toLowerCase());
        if (uUID == null) {
            uUID = this.NameMap.get(string.toLowerCase());
        }
        return uUID;
    }

    public List<String> getNickNamesStartingWith(Player player, String string) {
        string = string.toLowerCase();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, UUID> entry : this.NickMap.entrySet()) {
            if (!entry.getKey().startsWith(string)) continue;
            Player player2 = CMIUser.getOnlinePlayer(entry.getValue());
            if (player == null || player2 == null || !player.canSee(player2)) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    public void load() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("DisplayName.Change", new String[]{"If you have 3rd party plugin changing players display name, set this to false"});
        this.DisplayNameChange = configReader.get("DisplayName.Change", Boolean.valueOf(true));
        configReader.addComment("DisplayName.Format", new String[]{"Format of players display name. By default only nick name will be visible, if its set, if not, then players name", "Possible custom varibales: {prefix} {suffix} {nicknameprefix}", "Supports placeholders"});
        this.NickNameFormat = configReader.get("DisplayName.Format", configReader.getC().getString("NickName.Format", "{nickName}"));
        configReader.addComment("DisplayName.ValidNicknameRegex", new String[]{"Defines regex for valid nick name", "By default only letters and numbers are allowed", "If you want to allow any letter from any language use [^\\p{L}0-9\\-\\_]"});
        this.ValidNickNameRegex = configReader.get("DisplayName.ValidNicknameRegex", "[^a-zA-Z0-9\\-\\_]");
        configReader.addComment("NickName.BlackList", new String[]{"Prevents players to change their nick name to one of defined without permission", "Use lower case", "cmi.command.nick.bypassblacklist", "to bypass protection against already in use name/nickname use cmi.command.nick.bypassinuse"});
        this.NickNameBlackList = configReader.get("NickName.BlackList", Arrays.asList("admin", "administrator", "server", "staff", "staf"));
        int n = 0;
        while (n < this.NickNameBlackList.size()) {
            this.NickNameBlackList.set(n, this.NickNameBlackList.get(n).toLowerCase());
            ++n;
        }
        configReader.addComment("NickName.MinLength", new String[]{"Min length of nick name, can be bypassed with cmi.command.nick.bypass.length"});
        this.NickNameLengthMin = configReader.get("NickName.MinLength", 4);
        configReader.addComment("NickName.MaxLength", new String[]{"Max length of nick name, can be bypassed with cmi.command.nick.bypass.length"});
        this.NickNameLengthMax = configReader.get("NickName.MaxLength", 16);
        configReader.addComment("NickName.Prefix", new String[]{"Adds prefix for players nickname to indicate that its not real name. This can be added to display name with {nicknameprefix}"});
        this.NickNamePrefix = configReader.get("NickName.Prefix", "~");
        configReader.addComment("NickName.PrefixWhenDifferent", new String[]{"When true, will only add nickname prefix when its not same as original name. This can allow colorization or capitalization change without adding prefix"});
        this.PrefixWhenDifferent = configReader.get("NickName.PrefixWhenDifferent", Boolean.valueOf(false));
        configReader.addComment("NickName.TabComplete.ReplaceReal", new String[]{"When true, online players nick name will be used instead of real name in tabcomplete"});
        this.IncludeInTabComplete = configReader.get("NickName.TabComplete.ReplaceReal", Boolean.valueOf(configReader.getC().getBoolean("NickName.IncludeInTabComplete", true)));
        configReader.addComment("NickName.TabComplete.IncludeReal", new String[]{"When true, we will include real name on top of nickname. This only has effect when ReplaceName is enabled"});
        this.IncludeRealName = configReader.get("NickName.TabComplete.IncludeReal", Boolean.valueOf(false));
    }

    public String getNickNameFormat() {
        return this.NickNameFormat;
    }

    public List<String> getNickNameBlackList() {
        return this.NickNameBlackList;
    }

    public int getNickNameLengthMax() {
        return this.NickNameLengthMax;
    }

    public int getNickNameLengthMin() {
        return this.NickNameLengthMin;
    }

    @Deprecated
    public Boolean isColorsNickName() {
        return this.plugin.getChatManager().isColorsNickName();
    }

    public String getNickNamePrefix() {
        return this.NickNamePrefix;
    }

    public void setNickNamePrefix(String string) {
        this.NickNamePrefix = string;
    }

    public Boolean isPrefixWhenDifferent() {
        return this.PrefixWhenDifferent;
    }

    public void setPrefixWhenDifferent(Boolean bl) {
        this.PrefixWhenDifferent = bl;
    }

    public String getValidNickNameRegex() {
        return this.ValidNickNameRegex;
    }

    public boolean isDisplayNameChange() {
        return this.DisplayNameChange;
    }

    public boolean isIncludeNickNameInTabComplete() {
        return this.IncludeInTabComplete;
    }

    public Boolean isIncludeRealNameInTabComplete() {
        return this.IncludeRealName;
    }
}

