/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Particl;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Particl.CMIPEAnimationInterface;
import com.Zrips.CMI.Modules.Particl.ParticleManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CMIVisualEffect {
    private Player targetPlayerLocation;
    private Location loc;
    int id = -1;
    private int interval = 1;
    private Long until = null;
    private CMIPEAnimationInterface effectAnimation = null;
    List<Player> players = new ArrayList<Player>();
    Long nextPlayerUpdate;

    public CMIVisualEffect(Player player, ParticleManager.CMIPresetAnimations cMIPresetAnimations) {
        this(player, cMIPresetAnimations.getInter(player));
    }

    public CMIVisualEffect(Player player, CMIPEAnimationInterface cMIPEAnimationInterface) {
        if (cMIPEAnimationInterface != null) {
            if (cMIPEAnimationInterface.getCenter() != null) {
                this.loc = cMIPEAnimationInterface.getCenter().clone();
            }
            this.effectAnimation = cMIPEAnimationInterface;
            this.interval = cMIPEAnimationInterface.getInterval();
        }
        this.setTargetPlayer(player);
    }

    public CMIVisualEffect(Location location, CMIPEAnimationInterface cMIPEAnimationInterface) {
        this.loc = location;
        this.effectAnimation = cMIPEAnimationInterface;
        if (cMIPEAnimationInterface != null) {
            this.interval = cMIPEAnimationInterface.getInterval();
        }
    }

    private Location getLocation() {
        if (this.loc != null) {
            return this.loc;
        }
        return this.getTargetPlayer() != null ? (this.getTargetPlayer().isOnline() ? this.getTargetPlayer().getLocation() : null) : null;
    }

    public void show() {
        if (this.effectAnimation == null) {
            return;
        }
        this.id = Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)CMI.getInstance(), new Runnable(){

            @Override
            public void run() {
                Location location = CMIVisualEffect.this.getLocation();
                if (location == null) {
                    CMIVisualEffect.this.stop();
                    return;
                }
                if (CMIVisualEffect.this.nextPlayerUpdate == null || CMIVisualEffect.this.nextPlayerUpdate < System.currentTimeMillis()) {
                    CMIVisualEffect.this.players = CMI.getInstance().getUtilManager().getPlayersFromRange(CMIVisualEffect.this.getEffect().isHideWithVanish() ? CMIVisualEffect.this.getTargetPlayer() : null, location, 32);
                    CMIVisualEffect.this.nextPlayerUpdate = System.currentTimeMillis() + 1000L;
                }
                if (!CMIVisualEffect.this.effectAnimation.isFixedLocation() || CMIVisualEffect.this.effectAnimation.getCenter() == null) {
                    CMIVisualEffect.this.effectAnimation.setCenter(location);
                }
                CMIVisualEffect.this.visualize();
                if (CMIVisualEffect.this.until == null || CMIVisualEffect.this.until < System.currentTimeMillis()) {
                    CMIVisualEffect.this.stop();
                    return;
                }
            }
        }, 0L, (long)this.interval);
    }

    public void show(Player player) {
        this.players.clear();
        if (player != null) {
            this.players.add(player);
        }
        this.id = Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)CMI.getInstance(), new Runnable(){

            @Override
            public void run() {
                Location location = CMIVisualEffect.this.getLocation();
                if (location == null) {
                    CMIVisualEffect.this.stop();
                    return;
                }
                if (!CMIVisualEffect.this.effectAnimation.isFixedLocation() || CMIVisualEffect.this.effectAnimation.getCenter() == null) {
                    CMIVisualEffect.this.effectAnimation.setCenter(location);
                }
                CMIVisualEffect.this.visualize();
                if (CMIVisualEffect.this.until == null || CMIVisualEffect.this.until < System.currentTimeMillis()) {
                    CMIVisualEffect.this.stop();
                    return;
                }
            }
        }, 0L, (long)this.interval);
    }

    private void visualize() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)CMI.getInstance(), new Runnable(){

            @Override
            public void run() {
                Location location = CMIVisualEffect.this.getLocation();
                if (location == null) {
                    CMIVisualEffect.this.stop();
                    return;
                }
                if (CMIVisualEffect.this.effectAnimation == null) {
                    CMIVisualEffect.this.stop();
                    return;
                }
                if (!CMIVisualEffect.this.effectAnimation.render(new ArrayList<Player>(CMIVisualEffect.this.players))) {
                    CMIVisualEffect.this.stop();
                    return;
                }
            }
        });
    }

    public void stop() {
        if (this.id != -1) {
            Bukkit.getScheduler().cancelTask(this.id);
            this.id = -1;
            CMI.getInstance().getParticleManager().removePlayerEffects(this);
        }
    }

    public void pause() {
    }

    public void continueAnimation() {
    }

    public CMIPEAnimationInterface getEffect() {
        return this.effectAnimation;
    }

    public void setEffect(CMIPEAnimationInterface cMIPEAnimationInterface) {
        this.effectAnimation = cMIPEAnimationInterface;
    }

    public Player getTargetPlayer() {
        return this.targetPlayerLocation;
    }

    public void setTargetPlayer(Player player) {
        this.targetPlayerLocation = player;
        if (this.loc == null) {
            CMI.getInstance().getParticleManager().addPlayerEffect(this);
        }
    }

    public Long getUntil() {
        return this.until;
    }

    public void setUntil(Long l) {
        this.until = l;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int n) {
        this.interval = n;
    }
}

