/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.PlayTime;

import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.PlayTime.PlayTimeManager;

public class CMIPlayDay {
    Long[] map = new Long[24];
    private Long lastUpdate = null;
    private CMIUser user;
    private int date;
    private Integer id = 0;
    private static final Long maxValue = 3600000L;

    public CMIPlayDay(CMIUser cMIUser, int n) {
        this.user = cMIUser;
        this.date = n;
    }

    public Long getLastUpdate() {
        return this.lastUpdate;
    }

    public Long getTotalTime() {
        Long l = 0L;
        int n = 0;
        while (n < 24) {
            l = l + this.getHourPlaytime(n);
            ++n;
        }
        return l;
    }

    public void setLastUpdate(Long l) {
        this.lastUpdate = l;
    }

    public void updatePlayTime() {
        if (this.lastUpdate == null) {
            this.lastUpdate = System.currentTimeMillis();
            return;
        }
        int n = PlayTimeManager.PlaytimeRange.thishour.getStartTime();
        Long l = System.currentTimeMillis() - this.lastUpdate > PlayTimeManager.checkIntervalMs ? PlayTimeManager.checkIntervalMs : System.currentTimeMillis() - this.lastUpdate;
        Long l2 = this.map[n];
        if (l2 == null || l2 == 0L) {
            this.checkPreviousHour(n - 1);
        }
        l2 = l2 == null ? l : l2 + l;
        l2 = l2 < 0L ? 0L : l2;
        this.map[n] = l2 = l2 > maxValue ? maxValue : l2;
        this.lastUpdate = System.currentTimeMillis();
    }

    public void checkPreviousHour(int n) {
        if (n < 0) {
            return;
        }
        Long l = this.map[n];
        if (l == null) {
            return;
        }
        if (maxValue - l < 60000L) {
            this.map[n] = maxValue;
        }
        this.user.addForDelayedSave();
    }

    public Long getCurrentHourPlaytime() {
        return this.getHourPlaytime(PlayTimeManager.PlaytimeRange.thishour.getStartTime());
    }

    public Long getHourPlaytime(int n) {
        Long l = this.map[n];
        return l == null ? 0L : l;
    }

    public void setHourPlaytime(int n, Long l, boolean bl) {
        if (!bl) {
            l = l > maxValue ? maxValue : l;
        }
        this.map[n] = l = l <= 0L ? null : l;
    }

    public int getDate() {
        return this.date;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer n) {
        this.id = n;
    }
}

