/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Selection;

import com.Zrips.CMI.Modules.Portals.CMIPortal;
import com.Zrips.CMI.Modules.Portals.CuboidArea;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class Visualizer {
    private Player player;
    private long start;
    private List<CuboidArea> areas = new ArrayList<CuboidArea>();
    private List<CuboidArea> errorAreas = new ArrayList<CuboidArea>();
    private int id = -1;
    private int errorId = -1;
    private boolean once = false;
    private int starting = 0;
    private List<Location> locations = new ArrayList<Location>();
    private List<Location> errorLocations = new ArrayList<Location>();
    private List<Location> locations2 = new ArrayList<Location>();
    private List<Location> errorLocations2 = new ArrayList<Location>();
    private Location loc = null;

    public Visualizer(Player player) {
        this.player = player;
        this.start = System.currentTimeMillis();
    }

    public void cancelAll() {
        if (this.id != -1) {
            Bukkit.getScheduler().cancelTask(this.id);
        }
        if (this.errorId != -1) {
            Bukkit.getScheduler().cancelTask(this.errorId);
        }
        this.loc = null;
    }

    public boolean isSameLoc() {
        if (this.loc == null) {
            return false;
        }
        if (this.loc.getWorld() != this.player.getWorld()) {
            return false;
        }
        if (!this.errorAreas.isEmpty() && this.errorLocations.isEmpty()) {
            return false;
        }
        return !(this.loc.distance(this.player.getLocation()) > 1.0);
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long l) {
        this.start = l;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public List<CuboidArea> getAreas() {
        return this.areas;
    }

    public void setAreas(CMIPortal cMIPortal) {
        if (cMIPortal != null) {
            this.areas = Arrays.asList(cMIPortal.getArea());
        }
    }

    public void setAreas(CuboidArea[] cuboidAreaArray) {
        this.areas = Arrays.asList(cuboidAreaArray);
    }

    public void setAreas(ArrayList<CuboidArea> arrayList) {
        this.areas = arrayList;
    }

    public void setAreas(CuboidArea cuboidArea) {
        this.areas = new ArrayList<CuboidArea>();
        this.areas.add(cuboidArea);
    }

    public List<CuboidArea> getErrorAreas() {
        return this.errorAreas;
    }

    public void setErrorAreas(CMIPortal cMIPortal) {
        if (cMIPortal != null) {
            this.errorAreas = Arrays.asList(cMIPortal.getArea());
        }
    }

    public void setErrorAreas(CuboidArea[] cuboidAreaArray) {
        this.errorAreas = Arrays.asList(cuboidAreaArray);
    }

    public void setErrorAreas(ArrayList<CuboidArea> arrayList) {
        this.errorAreas = arrayList;
    }

    public void setErrorAreas(CuboidArea cuboidArea) {
        this.errorAreas.add(cuboidArea);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public int getErrorId() {
        return this.errorId;
    }

    public void setErrorId(int n) {
        this.errorId = n;
    }

    public boolean isOnce() {
        return this.once;
    }

    public void setOnce(boolean bl) {
        this.once = bl;
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public void setLocations(List<Location> list2) {
        this.locations = list2;
    }

    public List<Location> getLocations2() {
        return this.locations2;
    }

    public void setLocations2(List<Location> list2) {
        this.locations2 = list2;
    }

    public List<Location> getErrorLocations() {
        return this.errorLocations;
    }

    public void setErrorLocations(List<Location> list2) {
        this.errorLocations = list2;
    }

    public List<Location> getErrorLocations2() {
        return this.errorLocations2;
    }

    public void setErrorLocations2(List<Location> list2) {
        this.errorLocations2 = list2;
    }

    public Location getLoc() {
        return this.loc;
    }

    public void setLoc(Location location) {
        this.loc = location;
    }

    public int getStarting() {
        return this.starting;
    }

    public void setStarting(int n) {
        this.starting = n;
    }
}

